package server;

import java.rmi.RemoteException;

/**
 * A PlayerServer exposes upload critter permissions to the user.
 */
public interface PlayerServer extends Server {

	/**
	 * Upload a critter to the server.
	 * @param critterFileContent The string content of the critter definition file.
	 * @returns the name of the critter on the server, as it would be used in a world definition
	 * @throws RemoteException
	 */
	public String uploadCritter(String critterFileContent) throws RemoteException;
}