function board = read_moves(filename, move_number)
% Reads the list of moves from a text file, and returns
% the board state after a specified move (line) number.

f = fopen(filename,'r');

board = initialize();
move_id = 0;

while ~feof(f) && move_id < move_number
   move  = fscanf(f,'%c',5);
   temp  = fscanf(f,'%c',1); % 2 for Windows 
   board = move_piece(board, move); 
   move_id = move_id + 1;
end

fclose(f);

