function moves = possible_moves(board, bw, filename)
% Returns the possible moves on the current board.
% If bw is 0, moves correspond to White, if bw is 1
% moves correspond to Black. The moves are also written
% to a text file specified by its filename.
% The storage in the file should be in coordinate notation.
% Each move should occupy a single line.

t = [];
for r = 1:8
   for c = 1:8
      m = [];
      if bw == 0,
         switch board(r,c)
           case 1, m = pawn_moves(r,c,board,bw);  
           case 2, m = rook_moves(r,c,board,bw);
           case 3, m = knight_moves(r,c,board,bw);
           case 4, m = bishop_moves(r,c,board,bw);
           case 5, m = queen_moves(r,c,board,bw);
           case 6, m = king_moves(r,c,board,bw);
         end
      else
         switch board(r,c)
           case 7, m = pawn_moves(r,c,board,bw);
           case 8, m = rook_moves(r,c,board,bw);
           case 9, m = knight_moves(r,c,board,bw);
           case 10,m = bishop_moves(r,c,board,bw);
           case 11,m = queen_moves(r,c,board,bw);
           case 12,m = king_moves(r,c,board,bw);
         end
      end

      t = append_moves(r,c,t,m);
   end
end

moves = write_moves_to_file(t,filename);

function t = append_moves(r,c,t,m)
% Assuming m stores the target positions in two rows
l = size(m,2);
if l > 0,
t = [t, [[r*ones(1,l); c*ones(1,l)]; m]];
end

function moves = write_moves_to_file(t,fname)
moves = [ char(t(2,:)-1+'A');
          char(9-t(1,:)+'0'); 
          char(t(4,:)-1+'A');
          char(9-t(3,:)+'0')];
f = fopen(fname,'w');
for ii = 1:size(moves,2)
fprintf(f,'%c%c-%c%c\n',moves(1,ii),moves(2,ii),moves(3,ii),moves(4,ii));
end
fclose(f);
