function t = pawn_moves(r,c,board,bw)

t = [];

d = -1+2*bw; % direction based on player's color
if onboard(r+d,c),
  if isitempty(r+d,c,board), t = [t,[r+d;c]]; end
end

for j = c-1:2:c+1 % check diagonals for opponent 
   if onboard(r+d,j),
      if isopponent(r+d,j,board,bw) 
          t = [t,[r+d;j]];
      end
   end
end

if bw == 1 && r == 2, % starting position?
   if isitempty(r+1,c,board) && isitempty(r+2,c,board),
      t = [t, [r+2;c]];
   end
end

if bw == 0 && r == 7, % starting position?
   if isitempty(r-1,c,board) && isitempty(r-2,c,board),
      t = [t, [r-2;c]];
   end
end

