function v = isvalid(board)
% Checks if the matrix provided as a chessboard is valid
% Consider counting pieces, board size etc. You don't need
% to consider pawns reaching the lowest or highest ranks.
% (but in the solutions we did.)

% Check board size
if ~isequal(size(board),[8 8]), v = 0; return;

% Check number of pawns
nwp = sum(sum(board == 1)); % or use nnz function!
nbp = sum(sum(board == 7));
num_pawns = nwp < 9 && nbp < 9;
if ~num_pawns, v = 0; return;

% Number of kings
nwk = sum(sum(board == 6));
nbk = sum(sum(board ==12));
% We can only have one king for each player
if nwk ~= 1, v = 0; return;
if nbk ~= 1, v = 0; return;

% Number of bishops
nwb = sum(sum(board == 4));
nbb = sum(sum(board ==10));

% Number of knights
nwn = sum(sum(board == 3));
nbn = sum(sum(board == 9));

% Number of rooks
nwr = sum(sum(board == 2));
nbr = sum(sum(board == 8));

% Number of queens
nwq = sum(sum(board == 5));
nbq = sum(sum(board ==11));

% For each player initially we have two bishops sitting
% on black or white squares. For a player, we can ignore
% at most one bishop sitting on a white/black squares.
% The r+c value is even for white squares, and odd for
% black squares!

[rwb, cwb] = find(board == 4);
wb = rwb+cwb; % r+c values for White's bishops
wb_on_white = sum(rem(wb,2) == 0);
wb_on_black = sum(rem(wb,2) == 1);
% Minimum excess bishops for White 
nweb = max(wb_on_white - 1, 0) + max(wb_on_black - 1, 0); 

[rbb, cbb] = find(board == 4);
bb = rbb+cbb; % r+c values for White's bishops
bb_on_white = sum(rem(bb,2) == 0);
bb_on_black = sum(rem(bb,2) == 1);
% Minimum excess bishops for Black 
nbeb = max(wb_on_white - 1, 0) + max(wb_on_black - 1, 0);
 
% Excess pieces for White
nwe = nweb + max(nwn-2,0) + max(nwr-2,0) + max(nwq-2,0);
if (nwp-8) < nwe, v = 0; return;
% Excess pieces for Black
nbe = nbeb + max(nbn-2,0) + max(nbr-2,0) + max(nbq-2,0);
if (nbp-8) < nbe, v = 0; return;

% Two kings can't be neighbors!
[rwk, cwk] = find(board == 6);
[rbk, cbk] = find(board ==12);
if abs(rwk-rbk) == 1 || abs(cwk-cbk) == 1, v = 0; return;
 
% The pawns of a given player can't be at their home rank!
wp = sum(sum(board(1,:) == 7));
bp = sum(sum(board(8,:) == 1));
if wp > 0 || bp > 0, v = 0; return;
