function t = bishop_moves(r,c,board,bw)
t = [];
j = c;
blocked = 0;
for i = (r+1):8     % South-West direction
   j = j - 1;
   if j > 0 && possible(i,j), t = [t, [i;j]]; end
   if blocked, break; end
end

k = c;
blocked = 0;
for i = (r+1):8     % South-East direction
   k = k + 1;
   if k < 9 && possible(i,k), t = [t, [i;k]]; end
   if blocked, break; end
end

j = c;
for i = (r-1):-1:1  % North-West direction
   j = j - 1;
   if j > 0 && possible(i,j), t = [t, [i;j]]; end
   if blocked, break; end
end

k = c;
blocked = 0;
for i = (r-1):-1:1  % North-East direction
   k = k + 1; 
   if k < 9 && possible(i,k), t = [t, [i;k]]; end
   if blocked, break; end
end

function p = possible(a,b)
   p = ~blocked && canmove(a,b,board,bw);
   if ~isitempty(a,b,board),
     blocked = 1;
   end
end % possible

end % bishop_moves
