#!/usr/local/bin/perl
use Socket;
#use strict;

BEGIN {$ENV{PATH} = '/usr/sbin'}

use Carp;
use FileHandle;

sub spawn;
sub logmsg {print "$0 $$: @_ at ", scalar localtime, "\n"}

my($port) = @ARGV;
my $proto = getprotobyname('tcp');

# HTTP information
my $httpstatus = "HTTP/1.0 299 Eye: Command Accept\n";
my $mimeheader = "Content-Type: multipart/mixed;\nboundary=EyeMimeBound\n";
my $mimeboundary = "\n--EyeMsgBound\n";
my $mimeterminate = "\n--EyeMsgBound--\n";


socket(Server, PF_INET, SOCK_STREAM, $proto) or die "socket $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, pack("l", 1))
 or die "setsockopt: $!";

bind(Server, sockaddr_in($port, inet_aton("sim1.cs.cornell.edu"))) or die "bind: $!";
listen(Server, SOMAXCONN) or die "listen: $!";

logmsg "server started on port $port";

my $waitedpid = 0;
my $paddr;

sub REAPER {
    $waitedpid = wait;
    $SIG{CHLD} = \&REAPER;
    logmsg "reaped $waitedpid" . ($? ? " with exit $?" : "");
}

sub send_sock {
    my ($text) = @_;
#    send Client, (pack 'N', length $text), 0;
    send Client, $text, 0;
}

$SIG{CHLD} = \&REAPER;

my $line;

my $inputline;

local *FOO;

my $eyepassword = "brainrq";

for (; $paddr = accept(Client, Server); close Client) {
    my($port, $iaddr) = sockaddr_in($paddr);
    my $name = gethostbyaddr($iaddr, AF_INET);

    logmsg "connection from $name [",inet_ntoa($iaddr), "] at port $port";

    spawn sub {
	while (1) {
	    $line = <Client>;
	    if ($line =~ /^POST $eyepassword/) {
	    while ($line = <Client>) {
		if($line =~ /^(bping|ping|ftraceroute|traceroute)/) {
		    &send_sock($httpstatus);
		    &send_sock($mimeheader);
		    &send_sock($mimeboundary);
		    $line =~ s/\n//g;
		    &send_sock("<answer to: $line>\n");
		    open(FOO, ($line . "|"));
		    while($inputline = <FOO>) {
			print $inputline;
			&send_sock($inputline);
		    }
		    close FOO;
		    &send_sock("</answer>\n");
		    &send_sock($mimeterminate);
		}
	    }}
	    while (<Client>){}
	}
    };
}

sub spawn {
    my $coderef = shift;

    unless (@_ == 0 && $coderef && ref($coderef) eq 'CODE') {
	confess "usage: spawn CODEREF";
    }

    my $pid;
    if(!defined($pid = fork)) {
	logmsg "can't fork: $!";
	return;
    } elsif ($pid) {
	logmsg "spawned $pid";
	return;
    }

    open(STDIN, "<&Client") or die "can't dup client to stdin";
    open(STDOUT, ">&Client") or die "cand dup client to stdout";
    exit &$coderef();
}

