#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <netdb.h>

//#define PORTNUM 53333
#define ARG_SIZE 1024
#define ANSWER_LEN 8000
#define LINE_LEN 1024
#define N_ARG 64
#define MAX_CONNECTION 5
#define MAXHOSTNAME 256

int PORTNUM = 53434;

void fireman(int arg);
void do_something(int);

void fireman(int arg)
{
  while (waitpid(-1, NULL, WNOHANG) > 0);
}

char *DiscardSpace(char *str)
{
  while (*str == ' ')
    str++;

  return str;
}

/* parse command string into (int argc, char **argv) format
 */
int Parse(char *line, char **argv, int argc)
{
  char arg[ARG_SIZE];
  char *nextSpace;
  int n;

  line = DiscardSpace(line);
  while (*line) {
    /* line is at the start of next argument */
    sscanf(line, "%s", arg);
    n = strlen(arg);
    // printf("n = %d, %s\n", n, arg);
    argv[argc] = (char *) malloc(n+1);
    if (!argv[argc])
      return 0;
    strcpy(argv[argc], arg);
    argc++;
    line = DiscardSpace(line + n);
  }
  return argc;
}

/* wait for a connection to occur on a socket created with establish()
 */
int get_connection(int s)
{ int t;                  /* socket of connection */

  if ((t = accept(s,NULL,NULL)) < 0)   /* accept connection if there is one */
    return(-1);
  return(t);
}

int establish(unsigned short portnum)
{
  char myname[MAXHOSTNAME+1];
  int s;
  struct sockaddr_in sa;
  struct hostent *hp;

  memset(&sa, 0, sizeof(struct sockaddr_in));
  gethostname(myname, MAXHOSTNAME);
  hp = gethostbyname(myname);
  if (hp == NULL)
    return -1;
  sa.sin_family = hp->h_addrtype;
  sa.sin_port = htons(portnum);
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    return -1;
  if (bind(s, (struct sockaddr *) &sa, sizeof(struct sockaddr_in)) < 0) {
    close(s);
    return -1;
  }
  listen(s, MAX_CONNECTION);
  return(s);
}

/* read n bytes from a socket, return number of bytes left */
int readn(int socket, char *buf, int len)
{
  size_t nleft;
  ssize_t nread;
  char *ptr;

  ptr = buf;
  nleft = len;
  while (nleft > 0) {
    if ((nread = read(socket, ptr, nleft)) < 0) {
      if (errno == EINTR)
	nread = 0;
      else
	return -1;
    } else if (nread == 0)
      break;

    nleft -= nread;
    ptr += nread;
  }

  return nleft;
}

void ConnectBrain(int socket)
{
  int argc = 0, i;
  char *argv[N_ARG];
  char line[LINE_LEN];
  char answer[ANSWER_LEN];
  int requestLen = 0;

  printf("one eye logged in\n");

  while (1) {
    if (readn(socket, (char *) &requestLen, sizeof(requestLen))) 
      goto Error;
    requestLen = ntohl(requestLen);

    if (readn(socket, line, requestLen))
      goto Error;

    line[requestLen-1] = NULL; /* truncate the \n at the end */
//    printf("%s\n", line);

    argc = Parse(line, argv, 0);

    if (!argc)
      break;

    sprintf(answer, "<answer to : %s>\n", line);
    send(socket, answer, strlen(answer), 0);

    if (strcmp(argv[0], "ping") == 0) {
      bping(argc, argv, answer, ANSWER_LEN);
      send(socket, answer, strlen(answer), 0);
    }
    else if (strcmp(argv[0], "traceroute") == 0) {
      traceroute(argc, argv, answer, ANSWER_LEN);
      send(socket, answer, strlen(answer), 0);
    }
    else if (strcmp(argv[0], "quit") == 0)
      break;
    else {
      sprintf(answer, "invalid command\n");
      send(socket, answer, strlen(answer), 0);
    }

    sprintf(answer, "</answer>\n");
    send(socket, answer, strlen(answer), 0);
  }

Error:
  close(socket);
  for (i=0; i<argc; i++)
    free(argv[i]);
}

int main(int argc, char **argv)
{
  int s, t;


  if (argc < 2)
    return 1;
  PORTNUM = atoi(argv[1]);

#ifdef HAVE_SETLINEBUF
	setlinebuf (stdout);
#else
	setvbuf(stdout, NULL, _IOLBF, 0);
#endif
  
  if ((s = establish(PORTNUM)) < 0) {
    perror("establish");
    exit(1);
  }

  signal(SIGCHLD, fireman);

  for (;;) {
    if ((t = get_connection(s)) < 0) {
      if (errno == EINTR)
	continue;
      perror("accept");
      exit(1);
    }
    switch (fork()) {
    case -1:
      perror("fork");
      close(s);
      close(t);
      return 1;
    case 0:     /* child */
      close(s);
      ConnectBrain(t);
      return 0;
    default:    /* parent */
      close(t);
      continue;
    }
  }
}
