
sub tracert_init {
    
    $TRACES_SENT = 0;
    $TRACES_RECIEVED = 0;

  if ($USE_EYE) {return 1;}
# for UNIX systems, you never know where they put traceroute.
  if ( -x "/usr/local/etc/ftraceroute") {
      $TRACERT="/usr/local/etc/ftraceroute -n"; 
  } elsif (-x "/usr/local/sbin/ftraceroute") {
      $TRACERT="/usr/local/sbin/ftraceroute -n";
  } elsif (-x "/usr/sbin/ftraceroute") {
      $TRACERT="/usr/sbin/ftraceroute -n";
  } elsif ( -x "/usr/etc/ftraceroute") {
      $TRACERT="/usr/etc/ftraceroute -n"; 
  } else {
      print STDERR "error: could not find traceroute\n";
      return 0;
  }  
 
  return 1;
}

sub tracert_print_stats {
    log_message (4, "Traces sent $TRACES_SENT, Traces received $TRACES_RECIEVED");
#    print "TRACERT_TIMEOUT = $TRACERT_TIMEOUT\n";
}

#Input:.....minttl!
#Output:
sub tracert
  {my ($dest, $timeout, $minttl) = @_;
   my (@addrs,$ttl);

   $TRACES_SENT++;

   @addrs=();
   $ttl=0;
log_message(5, "$TRACERT -w $timeout -f $minttl $dest");
unless ($USE_EYE) {
  open(TRACERTFOO, "$TRACERT -w $timeout -f $minttl $dest|");
   while(<TRACERTFOO>)
     {next if (/^!!/);

      if (/.*([0-9]+).*\s([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+).*/)
	{$TRACES_RECIEVED++;
	 $ttl=$1;
	 push(@addrs, "$2.$3.$4.$5");
	}
      elsif (/.*\*.*/) 
	{$TRACES_RECIEVED++;
#	 print STDERR "tracert: Path broken or ICMP failed\n";
	 close(TRACERTFOO);
	 return ['*',"$ttl",@addrs];
       }
    }
   close(TRACERTFOO);
   return ['OK',"$ttl",@addrs];
} else {
    return remoteinvoke ('SOCKET','tracert',@_);
  }
 }

sub tracert_ignore_errors {
    local($dest) = @_;
    local($FOO);
    local($addrs);
    local($blah) = 0;
    $TRACES_SENT++;
####################To be revised!!!!!!!!!!!!!!!!!!!!!!!!
    open(FOO, "$TRACERT $dest|");
    while(<FOO>) {
	if (/.*[\d+.*ms|\*].*[\d+.*ms|\*].*[\d+.*ms|\*].*\s([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+).*/) {
	    push(@$addrs, "$1.$2.$3.$4");
	    $TRACES_RECIEVED++;
	} elsif (/.*\s([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+).*(\d+.*ms|\*).*(\d+.*ms|\*).*(\d+.*ms|\*).*/) {
	    push(@$addrs, "$1.$2.$3.$4");
	    $TRACES_RECIEVED++;
	} elsif (/.*\*\s*\*\s*\*.*/) {
	    $TRACES_RECIEVED++;
	    push(@$addrs, "0.0.0.0");
	    print STDERR "tracert: Path broken or ICMP failed\n";
	    close(FOO);
	    return $addrs;
	} elsif (/.*!H.*/) {
	    $TRACES_RECIEVED++;
	    push(@$addrs, "0.0.0.0");
	    print STDERR "tracert: Unix: Host unreachable\n";
	    close(FOO);
	    return $addrs;
	} elsif (/.*Destination host unreachable.*/) {
	    $TRACES_RECIEVED++;
	    push(@$addrs, "0.0.0.0");
	    print STDERR "tracert: Windows: Host unreachable\n";
	    close(FOO);
	    return $addrs;
	}
    }
    close(FOO);
    return $addrs;
}


return 1;

