
sub log_init
  {my ($dir)=@_;
   my ($sec,$min,$hour,$mday,$mon,$year)=localtime(time);
   my $filename;

   if ($dir eq 'nologging') {
     $NOLOGGING=1;
     return;
   }
   $year+=1900;
   $mon++;
   $filename=sprintf("$dir/logfile.$year.%02u.%02u.%02u.%02u",
		    $mon,$mday,$hour,$min);

   open (THELOGFILE,">$filename") or  die "Cannot open log file $filename";
 }

sub set_log_identity
  {my ($identity)=@_;

   if ($identity)
     {$LOGGING_IDENTITY="$identity ";}
   else
     {$LOGGING_IDENTITY='';}
 }

my @logprefix=("##### ",# 0 Fatal error
	       "#### ",# 1 Internal inconsistency (=bug)
	       "### ",# 2 Major external inconsistency
	       "## ",# 3 Minor external inconsistency
	       "# ",# 4 Information
	       " ");# 5 Debugging output
sub log_message
  {my ($level,$message)=@_;
   $l=$logprefix[$level].$LOGGING_IDENTITY.$message."\n";

   unless ($NOLOGGING){
     my($old) = select(THELOGFILE);
     $| = 1;
     print $l;
     $| = 0;
     select($old);   
   }
#   print THELOGFILE $logprefix[$level].$LOGGING_IDENTITY.$message."\n";
if ($level >= 4) {syswrite STDERR,$l,length($l);}
 }
