#Functions dealing with the initializations

#Only the first four functions are called from outside this file. They
#access the command line options which are global variables.

#Initialization in the single process case
sub init_single {
  &init_common();
  &init_central();
  &init_worker();
  &init_dbinterface_local();
  &log_init($database);
  &set_log_identity('');#all logging comes from the same process
  $ctx_give_job=\&give_local_job;
}

#Initialization in the external worker case
sub init_external_worker {
  &init_common();
  &init_worker();
  &init_dbinterface_remote();
  &log_init($identity);#a private log for each worker
  &set_log_identity('');#this worker is the only one logging there
}

#Initialization in the external central process case
sub init_external_central {
  &init_common();
  &init_central();
  &log_init($database);
  &set_log_identity('');#only the central process logs here
  $ctx_give_job=\&give_remote_job;
  if ($historyfile) {
    $ctx_histjobs=1;
    &read_history($historyfile);
  }
}

#Initialization in the forked case
sub init_forked {
  my ($i);
  &init_common();
  $UNIXSOCKET="$UNIXSOCKET$$";
  &init_central();
  &log_init($database);
  for ($i=1;$i<=$nworkers;$i++) {
    unless (fork) { #worker
      &init_worker();
      &set_log_identity("Worker$i ");
      &init_dbinterface_remote();
      &worker_main(); #this exits 
    }
  }
  &set_log_identity("Central ");
  $ctx_give_job=\&give_remote_job;
  if ($historyfile) {
    $ctx_histjobs=1;
    &read_history($historyfile);
  }
  &central_main();
}

#####################################################################

#Initializes the functions that work with the database for the single 
#process case
sub init_dbinterface_local{
  $REMOTENESS='local';
  $ctx_report_subdomains=\&report_subdomains;
  $ctx_report_ip_class=\&report_ip_class;
  $ctx_check_visited=\&check_visited;
  $ctx_store_computers=\&store_computers;
  $ctx_store_paths=\&store_paths;
  $ctx_report_dead=\&report_dead;
  $ctx_unvisited_routers=\&unvisited_routers;
  $ctx_process_router_hints=\&process_router_hints;
  $ctx_UpdateRtt = \&UpdateRtt;
  $ctx_hist_gen = \&hist_gen;
  $ctx_is_interesting = \&is_interesting_dotted; #yes, dotted
}

#Initializes the functions that work with the database for the
#multiprocess case 
sub init_dbinterface_remote{
  $REMOTENESS='remote';
  $ctx_report_subdomains=\&remote_report_subdomains;
  $ctx_report_ip_class=\&remote_report_ip_class;
  $ctx_check_visited=\&remote_check_visited;
  $ctx_store_computers=\&remote_store_computers;
  $ctx_store_paths=\&remote_store_paths;
  $ctx_report_dead=\&remote_report_dead;
  $ctx_unvisited_routers=\&remote_unvisited_routers;
  $ctx_process_router_hints=\&remote_process_router_hints;
  $ctx_UpdateRtt = \&remote_UpdateRtt;
  $ctx_hist_gen = \&remote_hist_gen;
  $ctx_is_interesting = \&remote_is_interesting;
}

#Initializations that have to happen only in the central process
sub init_central{
  $g_nDefaultPingTimeout = ($defaulttimeout or 3000);   #in ms
  $g_nMaxRtt = 0;
  $g_nMinRtt = 10000000;
  $g_nTotRtt = 0;
  $g_nHostPinged = 0;

  $MAX_MASK=&dotted2long('255.255.192.0');
     #(our guess of) the longest netmask that can be associated with a
     #single subnet (8190 computers!!)  
  #empty database
  @Router=('');
  @Subnet=('');
  @SNMPdata=('');
  %IP2Router=();
  %Domain=();
  $database=&database_init($database);
  &dns_init;################This shouldn't be here
  #The address of the function to decide what to do with a node that
  #falls outside the target domain. If it returns true the node is
  #added to the database anyway.
  $ctx_process_uninteresting= sub
    {&log_message(3 ,"Uninteresting>>".&serialize('IPdata',@_));
     return '';};
  #Comments to be filled in upon final code review
  $ctx_report_weird_case = sub 
    {my ($first,$bestip,$second,$router,$subnet)=@_; 
     &log_message(3,"Weird case>>".&long2dotted($first)."--".
		  &long2dotted($bestip)."--".&long2dotted($second)."--".
		  &sr($router)."--".&ss($subnet));};
  #Comments to be filled in upon final code review
  $ctx_report_bad_case = sub 
    {my ($first,$bestip,$second,$router,$subnet)=@_; 
     &log_message(3,"Bad case>>".&long2dotted($first)."--".
		  &long2dotted($bestip)."--".&long2dotted($second)."--".
		  &sr($router)."--".&ss($subnet));};
}

#Initializations that have to happen only in worker processes
sub init_worker {
  #various batch sizes for internal batching
  #very weird things happen if any of these is 0 
  $BS_PING = 20;
  $BS_AGAIN = 40;
  $SNMP_MAX_INTERFACES=500;
  $SNMP_MAX_ADDRS=1000;
  $SNMP_MAX_ROUTE=200000;
  $SNMP_MAX_ARP=100000;
  $persistance_factor=2+$aggressiveness;
  if ($eyecomputer and $eyeport and $eyepassword) {
    $USE_EYE=1;
    &call_socket($eyecomputer, $eyeport);
 }
  &ping_init;
  &dns_init;
  &tracert_init;
  #Sometimes, command line options will let us select other checkers
  #too
  $ctx_checker=\&h5_checker;
}

#Initializations common to all cases
sub init_common{
  $LOCALHOST=&dotted2long('127.0.0.1');
  $NULL_MASK=&dotted2long('0.0.0.0');
  $NO_SUCH_COMPUTER=&dotted2long('0.0.0.0');
  $MASK24=&dotted2long('255.255.255.0');
  $MASK22=&dotted2long('255.255.252.0');
  $MASK20=&dotted2long('255.255.240.0');
  $MASK19=&dotted2long('255.255.224.0');
  $MASK16=&dotted2long('255.255.0.0');
  $MASK12=&dotted2long('255.240.0.0');
  %Visited=();
  $UNIXSOCKET='/tmp/dbconnection'; #for the connection between the
                                   #central part of the brain and the
                                   #worker parts of it
  $HISTORY_LENGTH=50; #If a computer was last seen $HISTORY_LENGTH or
                      #more discoveries ago, drop it from the history
                      #file
}

return 1;
