use Socket;

#Converts from "long" representation used internally to dotted zecimal notation
sub long2dotted 
  {my($l) = @_;
   my(@bytes)=unpack ("C4",$l);

   return join ('.',@bytes);
 }

#Converts from dotted to long
sub dotted2long 
  {my($addr)=@_;

   if ($addr =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) 
     {return  pack ("C4",($1,$2,$3,$4));}
   else
     {log_message(1,"Invalid IP address $addr converted");}
   return '';
 }

#Input: an address in dotted format
#Output: '' if it's not routable, the address otherwise
sub routable_address
  {my($addr) = @_;
   my($a,$b);
   if ($addr =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) 
     {($a,$b)=($1,$2);}
   else
     {log_message(1,"Invalid IP address $addr checked");
      return '';}

   if ($a == 127 or $a == 10 or $a >= 224 or $a == 0)
     {return '';}
   elsif ($a == 192 and $b == 168)
     {return '';}
   elsif ($a == 172 and $b >= 16 and $b <= 31)
     {return'';}
   return $addr;
  }

#Input: an address in dotted format
#Output: '' if it's not valid, the address otherwise
sub valid_address
  {my($addr) = @_;
   my($i,@bytes);

   if ($addr =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) 
     {@bytes=($1,$2,$3,$4);}
   else
     {return '';}
   foreach $i (@bytes)
     {if ($i>255){return '';}}
   return $addr;
  }

#Input: a tentative netmask in long format (might have ones after the first
#zero if represented in base 2)
#Output: all digits after the first zero get zeroed
#I think these one can be improved....
sub fix_mask 
  {my ($temp_netmask) = @_;
   my ($i,$string);
   
   $string=unpack("B32",$temp_netmask);
   for ($i=0; $i<32 ;$i++)
     {last if (substr ($string,$i,1) eq '0')}
   for (; $i<32; $i++)
     {substr ($string,$i,1)='0';}
    return pack ("B32",$string);
 }

#Input: two netmasks (possibly with some ones after the first zero)
#Output: true if the first is more specific
#sub more_specific 
#  {my ($mask1,$mask2)=@_;
#   my(@bytes1)=unpack ("C4",$mask1);
#   my(@bytes2)=unpack ("C4",$mask2);
#   my $i;
#
#   for($i=0;$i<4;$i++)
#     {if($bytes1[$i] == $bytes2[$i])
#	{next;}
#      elsif($bytes1[$i] < $bytes2[$i])
#	{return 0;}
#      else
#	{return 1;}
#    }
#   return 0;
# }

#Since this function was the bottleneck I had to optimize it. The version
#below produces the exact same output with a speedup of roughly 3.5 times
sub more_specific {
  my ($mask1,$mask2)=@_;

  unless(substr($mask1,0,1) eq substr($mask2,0,1)) {
    if(ord(substr($mask1,0,1)) < ord(substr($mask2,0,1)))
      {return 0;}
    else
      {return 1;}
  }
  unless(substr($mask1,1,1) eq substr($mask2,1,1)) {
    if(ord(substr($mask1,1,1)) < ord(substr($mask2,1,1)))
      {return 0;}
    else
      {return 1;}
  }
  unless(substr($mask1,2,1) eq substr($mask2,2,1)) {
    if(ord(substr($mask1,2,1)) < ord(substr($mask2,2,1)))
      {return 0;}
    else
      {return 1;}
  }
  unless(substr($mask1,3,1) eq substr($mask2,3,1)) {
    if(ord(substr($mask1,3,1)) < ord(substr($mask2,3,1)))
      {return 0;}
    else
      {return 1;}
  }
  return 0;
}

#And the version that returns -1 if the first mask is more specific, 0
#if they are equal and 1 if the second one is more specific
sub more_specific_3 {
  my ($mask1,$mask2)=@_;

  unless(substr($mask1,0,1) eq substr($mask2,0,1)) {
    if(ord(substr($mask1,0,1)) < ord(substr($mask2,0,1)))
      {return 1;}
    else
      {return -1;}
  }
  unless(substr($mask1,1,1) eq substr($mask2,1,1)) {
    if(ord(substr($mask1,1,1)) < ord(substr($mask2,1,1)))
      {return 1;}
    else
      {return -1;}
  }
  unless(substr($mask1,2,1) eq substr($mask2,2,1)) {
    if(ord(substr($mask1,2,1)) < ord(substr($mask2,2,1)))
      {return 1;}
    else
      {return -1;}
  }
  unless(substr($mask1,3,1) eq substr($mask2,3,1)) {
    if(ord(substr($mask1,3,1)) < ord(substr($mask2,3,1)))
      {return 1;}
    else
      {return -1;}
  }
  return 0;
}

#Input: a netmask in CIDR format (e.g. 16)
#Output: the mask in internal representation
sub cidr2long {
  my ($cidr)=@_;

  if ($cidr>=0 and $cidr<32) {
    #you're free to come up with something faster
    my ($x,$string);
    for (($x,$string)=(0,'');$x<32;$x++){
      if ($x<$cidr) {$string.='1'} else {$string.='0'}
    }
    return pack ("B32",$string);
  } else {
    die "Invalid CIDR netmask $cidr";
  }
}

#Input: two addresses in the dotted format
#Output: <=> style result of their comparison
#sub compare_dotted
return 1;
