#Input: A normal IP address in the dotted format
#Output: All bytes get padded with 0s so that lexicografic comparison works
sub zeroify {
  my ($addr)=@_;
  my (@bytes)=split (/\./,$addr);
  my ($i);

  for ($i=0;$i<4;$i++) {
    $bytes[$i]=(substr('00',0,3-length($bytes[$i]))).$bytes[$i];
  }
  return join('.',@bytes);
}
#Remove leading zeroes from all bytes in the dotted format
sub unzeroify {
  my ($addr)=@_;
  my (@bytes)=split (/\./,$addr);
  my ($i);

  for ($i=0;$i<4;$i++) {
    $bytes[$i]=~s/^0*(.+)$/$1/;
  }
  return join('.',@bytes);
}

#Read data about live IP addresses information from a history file, construct 
sub read_history {
  my ($filename)=@_;
  my ($line,$crt_subnetC,$pcrt_list);

  unless (open (HISTORY,$filename)) {
    log_message(1, "Cannot open history file $filename");
    exit;
  }

  log_message(4, "Reading history file $filename");

  %History=();
  if ($ctx_histjobs) {
    $crt_subnetC='';
    @jq_hist=();
  }
  while ($line=<HISTORY>) {
    my ($addr,$lastseen,$subnetC);
    chop($line);
    ($addr,$lastseen)=split(' ',$line);
    $subnetC = $addr;
    unless ($subnetC =~ s/^(\d+)(\.\d+)(\.\d+)(\.\d+)$/$1$2$3/) {
      log_message(2,"Bad IP address in history file >$addr<");
      next;
    }
#print "  $subnetC ";
    if ($subnetC ne $crt_subnetC) { #we have a new subnetC
      if ($crt_subnetC) { #put the data of the old subnet in the job queue
	my ($first);
	if ($ctx_histjobs) {
	  push @jq_hist,$pcrt_list;
	  #make sure this prefix doesn't get discovered again
	  $first="$crt_subnetC.1";
	  add_unique (\@jq_ip,\%inq_ip,[$first]);
	  $done_ip{$first}=1;
	}
      }
      $pcrt_list=[];
      $crt_subnetC=$subnetC;
    }
    push @$pcrt_list,$addr;
    $History{&zeroify($addr)}=$lastseen+1;
  }
  log_message(4, (scalar keys %History)." computers in history file");

  #take care of the last subnetC
  if ($crt_subnetC) { #put the data of the old subnet in the job queue
    my ($first);
    if ($ctx_histjobs) {
      push @jq_hist,$pcrt_list;
      #make sure this prefix doesn't get discovered again
      $first="$crt_subnetC.1";
      add_unique (\@jq_ip,\%inq_ip,[$first]);
      $done_ip{$first}=1;
    }
  }

#die
}

#adds the addresses discovered in a previous run to the history
sub update_history {
  my ($historyfile,$ipfile)=@_;
  my (@histlist,$ip,$line,$n);

  unless (open (HISTORY,">$historyfile")) {
    log_message(1, "Cannot open history file $hitoryfile for writing");
    exit;
  }
  unless (open (IP,$ipfile)) {
    log_message(1, "Cannot open IP file $ipfile");
    exit;
  }
  $n=0;
  while ($line=<IP>) {
    my ($addr);
    chop($line);
    $n++;
    ($addr)=split(' ',$line);
    unless ($addr =~ /^(\d+)(\.\d+)(\.\d+)(\.\d+)$/) {
      log_message(4,"Bad IP address in file $ipfile>$addr<");
      next;
    }
#    $History{$addr}=1;
    $History{&zeroify($addr)}=1;
  }
  log_message(4, "$n computers in IP file");

  close IP;
  @histlist=sort keys %History;

  $n=0;
  foreach $ip (@histlist) {
    next if ($History{$ip}>$HISTORY_LENGTH);
    $n++;
    print HISTORY (&unzeroify($ip))." $History{$ip}\n";
  }
  log_message(4, "$n computers in new history file");
  close HISTORY;
}

#Writes to the history files the results of the current run
sub write_history {
  my ($historyfile)=@_;
  my (@histlist,$ip);

  unless (open (HISTORY,">$historyfile")) {
    log_message(0, "Cannot open history file $hitoryfile for writing");
    exit;
  }
  log_message(4, (scalar keys %History)." computers in old history file");
  foreach $ip (keys %IPdata) {
    $History{&zeroify(&long2dotted($ip))}=1;
  }
  @histlist=sort keys %History;
  foreach $ip (@histlist) {
    next if ($History{$ip}>$HISTORY_LENGTH);
    print HISTORY (&unzeroify($ip))." $History{$ip}\n";
  }
  log_message(4, (scalar keys %History)." computers in new history file");
}

return 1;
