#names we might find in a domain
@guesses=qw (www mail dns ns ftp home );
#names that are followed by a number (e.g. www1, www2, etc.)
@nguesses=qw (dhcp dhcp- dialup dialup- ppp adsl adsl- 
	      pc pc- mac ws
	      www mail ra home
	      hub afs test);

#Input: a domain name
#This heuristic is supposed to be used when DNS listing is not
#available. It tries to find some computers in the given domain and
#guess around them. This is most effective if the database detects all
#new IP address classes and subdomains (in is_interesting) and starts
#new jobs to do a fuller discovery
sub h6_gen {
  my ($domain)=@_;
#  my @ get name and mail servers and filter them
  my ($name,@names,$paddrl,$ip);
  my(@probe_addrs)=();#addresses that have to be probed
  my(@again_addrs)=();#addresses that get probed again
  local($do_traceroutes)=1;
  local ($ctx_info)=$domain;

  &log_message (4,"Starting h6-gen on $domain");
  #switching to the special store_computers
  if ($REMOTENESS eq 'local') {
    $ctx_store_computers=\&store_computers_h6;
  } else {
    $ctx_store_computers=\&remote_store_computers_h6;
  }

  @names=($domain,(map "$_.$domain",
		   (@guesses,(map {my ($sfx)=$_; map "$_$sfx",@nguesses}
			      (1..$persistance_factor)))));
#  print (join ' ',@names);
#print "\n\n".($#names+1);

  foreach $name (@names) {
    my (@addrs);
    if (@addrs=dns_name2addrs($name)) {
      add_addr(@addrs, \@probe_addrs);
    }
  }
  log_message(5,"Name guessing ratio ".(scalar @probe_addrs)." of ".
	      (scalar @names)." for $domain");
  $paddrl=&get_DNS_servers($domain);
  foreach $ip (@$paddrl) {
    $name=dns_addr2name($ip);
    if ($name =~ /\.$domain$/ or $name eq $domain) {
      add_addr($ip, \@probe_addrs);
    }

  }
  $paddrl=&get_mail_exchangers($domain);
  foreach $ip (@$paddrl) {
    $name=dns_addr2name($ip);
    if ($name =~ /\.$domain$/ or $name eq $domain) {
      add_addr($ip, \@probe_addrs);
    }

  }
#print "\n\n".($#probe_addrs+1);
#print "\n\n";
#.($#x+1);
#  die
  while ($#probe_addrs>=0 or $#again_addrs>=0) {
    my (@dead)=();
    my (@outside)=();#outside domain
    my (@alive)=();#means in fact traced to
    if ($#again_addrs>=$BS_AGAIN-1) {
      my ($i);
      for ($i=$BS_AGAIN-1;$i>=0;$i--){
	push (@dead,(shift @again_addrs));#just throw them away for now.
      }
    } elsif ($#probe_addrs>=0) {
      #do some probing
      my (@candidates)=();
      my ($timeout);
      while($#candidates<($BS_PING-1) and $#probe_addrs>=0) {
	$ip=shift @probe_addrs;
	next if ($Visited{$ip});
	push (@candidates,$ip);
      }
      #check with the database (global %Visited) and set status to probing
      ($timeout,@candidates)=&$ctx_check_visited(@candidates);
      #do the work
      local($ctx_dead)=\@again_addrs;
      local($ctx_outside)=\@outside;
      local($ctx_alive)=\@alive;
      &$ctx_checker($timeout,@candidates);
    } else { #a few retries left
      while ($#again_addrs>=0) {
	push (@dead,(shift @again_addrs));#just throw them away for now.
      }
    }
    #update %Visited on worker side
    foreach $ip (@dead)
      {$Visited{$ip}=3;}
    #report these to central too
    &$ctx_report_dead(@dead);
    #the live and outside ones get reported implicitly on the way
    foreach $ip (@outside)
      {$Visited{$ip}=5;}
    foreach $ip (@alive) {
      $Visited{$ip}=4;
      add_correlated_addrs($ip,\@probe_addrs);
    }
  }

  #switching back to the normal special store_computers
  if ($REMOTENESS eq 'local') {
    $ctx_store_computers=\&store_computers;
  } else {
    $ctx_store_computers=\&remote_store_computers;
  }

  &log_message (4,"Done with h6-gen on $domain");

}

return 1
