#the generator for heuristic 5 (IP address guessing)
#Input: an address and a netmask in the dotted form
#sub h5_gen {
#  my ($address,$mask)=@_;#
#
#print "$address  -  $mask\n";#
#
#  if ($mask !~ /^255\.255\.255\./) { #gotta break it up
#  my (@abyte,@mbyte,$i,$iprange,@netlist);
#  @abyte=split (/\./,$address);
#  @mbyte=split (/\./,$mask);
#  for ($i=0;$i<3;$i++) {
#    if ($mbyte[$i] eq 255) {
#      $iprange .= "$abyte[$i].";
#    } else {
#      my $high=$abyte[$i]+255-$mbyte[$i];
#      $iprange .= "[$abyte[$i]-$high].";
#    }
#  }
#  $iprange .='1';
#  print "$iprange\n\n";
#  @netlist=();
#  &ipmaker_all(\@netlist,$iprange);
#  &report_ip_class(@netlist);

#  } else { #go pinging
    
#  }
#}

#the real h5, working for a class C
#Input: one or more IP addresses from the target class
sub h5_gen_C {
  my (@addr)=@_;
  my ($ip);
  my(@probe_addrs)=();#addresses that have to be probed
  my(@again_addrs)=();#addresses that get probed again
  local($do_traceroutes)=1;
  local ($ctx_info)=$addr[0];

  &log_message (4,"Starting h5-gen-C on $addr[0] and other $#addr addresses");
  #Just doing this to add them to the add_addr cache in h5.pl
 # foreach $ip (@addr)
 #   {&add_addr(\@probe_addrs, $ip);}
  &add_addrs(\@addr,\@probe_addrs);
  if (@probe_addrs<2) {
    add_correlated_addrs($probe_addrs[0],\@probe_addrs);
  }
 # &log_message (4,"Starting h5-gen-C on $probe_addrs[0] and other $#probe_addrs addresses");

  while ($#probe_addrs>=0 or $#again_addrs>=0) {
    my (@dead)=();
    my (@outside)=();#outside domain
    my (@alive)=();#means in fact traced to
    if ($#again_addrs>=$BS_AGAIN-1) {
      my ($i);
      for ($i=$BS_AGAIN-1;$i>=0;$i--){
	push (@dead,(shift @again_addrs));#just throw them away for now.
      }
    } elsif ($#probe_addrs>=0) {
      #do some probing
      my (@candidates)=();
      my ($timeout);
      while($#candidates<($BS_PING-1) and $#probe_addrs>=0) {
	$ip=shift @probe_addrs;
	next if ($Visited{$ip});
	push (@candidates,$ip);
      }
      #check with the database (global %Visited) and set status to probing
      ($timeout,@candidates)=&$ctx_check_visited(@candidates);
      #do the work
      local($ctx_dead)=\@again_addrs;
      local($ctx_outside)=\@outside;
      local($ctx_alive)=\@alive;
      &$ctx_checker($timeout,@candidates);
    } else { #a few retries left
      while ($#again_addrs>=0) {
	push (@dead,(shift @again_addrs));#just throw them away for now.
      }
    }
    #update %Visited on worker side
    foreach $ip (@dead)
      {$Visited{$ip}=3;}
    #report these to central too
    &$ctx_report_dead(@dead);
    #the live and outside ones get reported implicitly on the way
    foreach $ip (@outside)
      {$Visited{$ip}=5;}
    foreach $ip (@alive) {
      $Visited{$ip}=4;
      add_correlated_addrs($ip,\@probe_addrs);
    }
  }

  &log_message (4,"Done with h5-gen-C on $addr[0] and other $#addr addresses");
}

sub hist_gen {
  return h5_gen_C(@_);
}

return 1;
