
sub h4_gen
  {my($domain)=@_;
   my($names,$subdoms,$name,$ip,@routerhints);

   local(@probe_addrs)=();#addresses that have to be probed
   local(@again_addrs)=();#addresses that get probed again
   local(%ip2name)=();#a dirty little local trick
   local($do_traceroutes)=1;
   local($ctx_info)=$domain;

   &log_message (4,"Starting h4-gen on $domain");
#   print STDERR "Starting h4-gen on $domain\n";
   ($names,$subdoms)=&dns_ls($domain);
   &log_message (4,"Got ".($#$names+1)." names and ".($#$subdoms+1).
		 " subdomains for domain $domain");
   if ($#$names+$#$subdoms == -2) {#no listing. Let's try something else
     h6_gen($domain);
     return;
   }

#   log_message(5,"Reporting subdomains");
   &$ctx_report_subdomains(@$subdoms);
#   log_message(5,"Reported subdomains");

   @routerhints=();
   while($#$names>=0)
     {$name=shift @$names;
      my(@iplist)=&dns_name2addrs($name);

      foreach $ip (@iplist)
	{push @probe_addrs,$ip;
	 $ip2name{$ip}=$name;
       }
      if ($#iplist>0)
	{push @routerhints,[$name,@iplist];}
    }
   log_message(5,"Reporting router hints");
   &$ctx_process_router_hints(@routerhints);

   while ($#probe_addrs>=0 or $#again_addrs>=0)
     {local (@dead)=();
      local (@outside)=();#outside domain
      local (@alive)=();#means in fact traced to
      if ($#again_addrs>=$BS_AGAIN-1)
	{my ($i);
	 for ($i=$BS_AGAIN-1;$i>=0;$i--)
	   {push (@dead,(shift @again_addrs));#just throw them away for now.
	  }
       }
      elsif ($#probe_addrs>=0)
	#do some probing
	{my (@candidates)=();
	 my ($timeout);
	 while($#candidates<($BS_PING-1) and $#probe_addrs>=0)
	   {$ip=shift @probe_addrs;
	    next if ($Visited{$ip});
	    push (@candidates,$ip);
	  }
	 #check with the database (global %Visited) and set status to probing
	 ($timeout,@candidates)=&$ctx_check_visited(@candidates);
	 #do the work
	 local($ctx_dead)=\@again_addrs;
	 local($ctx_outside)=\@outside;
	 local($ctx_alive)=\@alive;
	 &$ctx_checker($timeout,@candidates);
       }
      else #a few retries left
	{while ($#again_addrs>=0)
	   {push (@dead,(shift @again_addrs));#just throw them away for now.
	  }
       }
      #update %Visited on worker side
      foreach $ip (@dead)
	{$Visited{$ip}=3;}
      #report these to central too
      &$ctx_report_dead(@dead);
      #the live and outside ones get reported implicitly on the way
      foreach $ip (@outside)
	{$Visited{$ip}=5;}
      foreach $ip (@alive)
	{$Visited{$ip}=4;}
    }
   
   &log_message (4,"Done with h4-gen on $domain");
#   print STDERR "Done with h4-gen on $domain\n";
   return;
 }

return 1;
