#Description of the structure of the data stored in the database

%Scalar=
  #This is a list of the scalar types and functions to convert between the
  #in-memory representation and the representation on disk
  ('IP'=>[\&long2dotted,\&dotted2long],
   #IP addreses are stored internally as 4 bytes, externally in dotted form
   'Name'=>[\&no_processing,\&no_processing],
   'Delay'=>[\&no_processing,\&no_processing],
   'Mask'=>[\&long2dotted,\&dotted2long],
   'Text'=>[\&no_processing,\&no_processing],
   'Counter'=>[\&no_processing,\&no_processing],
  );

sub no_processing
  {my ($text)=(@_);
   return $text;}

%Enum=
  ('Subnet_method'=>['guessing','SNMP'],#higher number means we trust it more
   'Router_method'=>['DNS','correlation','SNMP'],
   'Visit_status'=>['unvisited','probing','alive','dead','traced',
		    'outsidedomain'],
  );

%Hash=
  ('Visited'=>['IP','1','VisitStatus'],
   'NS_CACHE'=>['Name','n','IP'],
   'NS_INV_CACHE'=>['IP','1','Name'],
   'IPdata'=>['IP','1',[['ip','1','IP'],
			['name','n','Name'],
			    #all names that it can be associated with
			['rtt','1','Delay'],
			['ttl','1','Counter'],
			    #ttl to computer on the direct path
			['hopsret','1','Counter'], #hops on the return path
			['lasthop','o','IP'], #last hop in traceroute
			['subnet','o','Subnet'],
			['traceip','o','IP'], #the IP that answers traceroutes
			['router','o','Router'],
			    #the router to which this ip belongs
			['link','n','IP'], #IPs that follow this in traces
		       ],
	     ],
   'Domain'=>['Name','1',[['delaymin','1','Delay'],
			  ['delaymax','1','Delay'],
			  ['delaysum','1','Delay'],
			  ['hosts','1','Counter'],
			  ['ttlskew','1','Counter'],
			 ],
	     ],
  );

%Object=
  #All objects are stored in text files, one on each line. Inside this
  #structure 1 means the attribute has exactly one value, m (multiple) means
  #one or more, n means 0 or more, o (optional) means 0 or 1
  ('Router'=>[['address','n','IP'],
	      ['method','1','Router_method'],
	      ['hint','1','Text'], #hints on how the router was discovered
	      ['snmpdata','o','SNMPdata'],
	     ],
   'Subnet'=>[['ip','1','IP'],
	      ['mask','1','Mask'],
	      ['method','1','Subnet_method'],
	      ['host','n','IP'],
	      ['lasthop','n','IP'],
	      ['ttlskew','1','Counter'],
	      #hops on forward path - hops on reverse path +1
	      ['delaymin','1','Delay'],
	      ['delaymax','1','Delay'],
	      ['delaysum','1','Delay'],
	      ['delayn','1','Counter'],#avg=sum/n
	     ],
   'SNMPdata'=>[['community','1','Text'],
		['sysDescr','o','Text'],
		['interfaces','n',[['ifIndex','o','Text'],
				   ['ifDescr','o','Text'],
				   ['ifType','o','Text'],
				   ['ifMtu','o','Text'],
				   ['ifSpeed','o','Text'],
				   ['ifOperStatus','o','Text'],
				  ]
		],
		['ipAddrTable','n',[['ip','1','IP'],
				    ['mask','1','IP'],
				    ['bcast','1','IP'],
				    ['ifIndex','1','Text'],
				   ],
		],
		['routeTable','n',[['dest','1','IP'],
				   ['mask','1','IP'],
				   ['nextHop','1','IP'],
				   ['ifIndex','1','Text'],
				   ['type','1','Text'],
				  ],
		],
		['arpTable','n','IP'],#In fact this doesn't get stored
	       ],
  );

return 1;

