#functions performing operations on the database.  All functions
#maintain the database consistency. They all operate with the internal
#representation for IP addresses (4bytes)

#Input: a list with the IP address of a computer, ping ttl, name and
#additional addresses of host or router to be added
#Output: IPdata or '' if it's rejected (because it's ousit=de the limits)
sub store_IPdata {
  my($addr,$hops,$rtt,$name,@otherips)=@_;
  my ($data,$id);
   
  if (defined ($data=$IPdata{$addr})){
     #we already have data about this address
    unless (grep {$name eq $_} @{$data->[1]}){
      push @{$data->[1]},$name
    }
    if ($data->[4] != $hops){
      log_message(3,"Hop count changed from $data->[4] to $hops for ".
		  &long2dotted($addr));
      $data->[4] = $hops;
    }
  } else {
    #build a new one
    $data=[$addr,[$name], $rtt];
    if (!&is_interesting($addr,$name)){
      if (!&$ctx_process_uninteresting($data)) {return ''}
    }
    $data->[4]=$hops;
    $IPdata{$addr}=$data;
    if ($id=$IP2router{$addr}){
      $data->[8]=$id
    }
  }
  if ($#otherips>=0){
    process_router_hint($name,$addr,@otherips);
  }
#print (&si($data)," + ",join (' ',(map {l2d($_)} @otherips)),"\n");
  return $data;
}

#Input: a name and a list of IPs it maps to (in long format)
sub process_router_hint
  {my ($name,@addrs)=@_;
   my (@routers,$ip,$i);

   #checking for duplicates
   for($i=0; $i<$#addrs ;$i++)
     {if (grep {$_ eq $addrs[$i]} @addrs[($i+1)..$#addrs])
	{log_message(3,"Duplicate address passed to router hints $name $i ".
		    (join(' ',(map {&long2dotted($_)} @addrs))));
	 $addrs[$i]='';}
    }
   @addrs=(grep {$_} @addrs);
   if ($#addrs<=0)
     {log_message(3,"Bad router hints $name ".
		    (join(' ',(map {&long2dotted($_)} @addrs)))); 
      return;}

   #do we have any routers that registered these addresses?
   @routers=();
   foreach $ip (@addrs)
     {my ($id)=$IP2router{$ip};
      if ($id)
	{unless (grep {$id eq $_} @routers)
	   {push @routers,$id}
       }
    }
   if ($#routers<0)
     #we know of no routers with these addresses
     {push @Router,[\@addrs,0,"DNS_$name"];
      foreach $ip (@addrs)
	{$IP2router{$ip}=$#Router;
	 if (defined ($i=$IPdata{$ip}))
	     {$i->[8]=$#Router;}
       }
    }
   elsif ($#routers == 0)
     #one router
     {my ($router)=$Router[$routers[0]];
      my (@newaddrs)=();
      foreach $ip (@addrs)
	{if ($IP2router{$ip} ne $routers[0])
	   {push @newaddrs,$ip}
       }
      if ($#newaddrs<0)
	#nothing to add
	{if ($router->[2] !~ /$name/)
	   {if ($#{$router->[0]} == $#addrs)
	      {$router->[2].=";DNS_confirmation_$name"}
	    else
	      {$router->[2].=";DNS_subset_$name"}}}
      else
	{if ($route->[1] == 2)#SNMP
	   {if ($router->[2] !~ /$name/)
	      {$router->[2].=";DNS_reject_hint_$name";
	       log_message(3,"Router hint $name rejected ".
			   (join(' ',(map {&long2dotted($_)} @addrs))).
			   &sr($router));}}
	 else
	   {$router->[2].="+DNS extension $name";
	    foreach $ip (@newaddrs)
	      {$IP2router{$ip}=$routers[0];
	       push @{$router->[0]},$ip;}
	  }
       }
    }
   else
     #too many routers
     {log_message(3, "Router hint $name ignored. Covers too many routers ".
		 (join(' ',(map {&long2dotted($_)} @addrs))).
		 (join(' ',(map {&pr($_)} @routers))));}
   return;
  }
#Stores link information derived from two IP addresses following each other
#in a traceroute
#Input: TTL of the first one, the 2 consecutive IPs + the traceroute
#destination address if this is the last link in the chain. If the first IP is
#'' then this was the only entry in a traceroute
sub store_link
  {my ($ttl,$first,$second,$dest)=@_;
   my ($data1,$data2,$data3);

#print "Chokah klick $ttl ".&l2d($first)." ".&l2d($second)." ".&l2d($fdest)."\n";
   #Updating $second's structure
   $data2=($IPdata{$second} or '');
   if(!$data2)
     {unless ($Visited{&long2dotted($second)} == 5)
	{log_message(1,"Tracerouting through unknown IP ".&l2d($second)
.'-'.$Visited{&long2dotted($second)}
);}
      return; #Or should I insist? Maybe.
    }
   if ($first)
     {$data2->[3]=$ttl+1;
      $data2->[5]=$first;}
   #Updating $dest
   if($dest)
     {$data3=$IPdata{$dest};
      if(!$data3)
	{unless ($Visited{&long2dotted($dest)} == 5)
	   {log_message(1,"Tracerouting to unknown IP ".&l2d($dest)
.'-'.$Visited{&long2dotted($dest)}
);}
	 return; #Or should I insist? Maybe.
       }
      if ($first)
	{$data3->[3]=$ttl+1;
	 $data3->[5]=$first;}
      if ($second ne $dest) 
	{$data3->[7]=$second;
	 &correlate($second,$dest);}
    }
   #Updating $first's structures
   $data1=$IPdata{$first};
   if(!$data1)
     {unless ($Visited{&long2dotted($first)} == 5 or $first eq '')
	{log_message(1,"Tracerouting through unknown router ".&l2d($first)
.'-'.$Visited{&long2dotted($first)}
);}}
   else
     {$data1->[3]=$ttl;
      if($data1->[8])
	{my($router)=$Router[$data1->[8]];
	 my ($ip,$subnet,$mask,$bestip);
	 $mask = $NULL_MASK;
	 #Check if it is in any of the subnets we know of
	 foreach $ip (grep {$_ ne $first} @{$router->[0]})
	   {my $datax=$IPdata{$ip};
	    if($datax)
	      {if($datax->[6]>0)
		 {$subnet=$datax->[6];
		  if ($subnet eq $data2->[6])#already located
		    {return;}#do nothing
		  elsif(($second & $Subnet[$subnet]->[1]) eq 
			$Subnet[$subnet]->[0])#fits in a subnet
		    {&add_ip_to_subnet($second,$subnet);
		     return;}
		  else
		    {my $temp_xor= ~($second ^ $Subnet[$subnet]->[0]);
		     if (&more_specific($temp_xor,$mask))
		       {$mask = $temp_xor;
			$bestip = $ip;}
		   }}
	       else
		 {my $temp_xor= ~($second ^ $ip);
		  if (&more_specific($temp_xor,$mask))
		    {$mask = $temp_xor;
		     $bestip = $ip;}
		}
	     }
	  }
	 #done cycling through the router's addresses
	 $mask = &fix_mask ($mask);
	 unless (&more_specific($MAX_MASK,$mask))
	   {my ($net,@overlap);
	    $net = $bestip & $mask;
	    @overlap = &overlapping_subnets($net,$mask);

	    if ($#overlap == -1)
	      {my $subnetid=&create_subnet($net,$mask);
	       &add_ip_to_subnet($second,$subnetid);
	       &add_gw_to_subnet($bestip,$subnetid);
	       return;}
	    elsif ($#overlap == 0) #overlapping with exactly one subnet
	      {if(&more_specific($Subnet[$overlap[0]]->[1],$mask))
		 #can extend an existing subnet
		 {if (&extend_netmask($Subnet[$overlap[0]],$mask))
		    {&add_ip_to_subnet($second,$overlap[0]);
		     unless ($data1->[6] eq $overlap[0])
		       {&add_gw_to_subnet($bestip,$overlap[0]);}
		     return;}}
	       else
		 {if ($Subnet[$overlap[0]]->[1] eq $mask)
		    {&$ctx_report_weird_case($first,$bestip,$second,$router,
					     $Subnet[$overlap[0]]);}
		  else
		    {&$ctx_report_bad_case($first,$bestip,$second,$router,
					  $Subnet[$overlap[0]]);}
		  &add_ip_to_subnet($second,$overlap[0]);
		  &add_gw_to_subnet($bestip,$overlap[0]);
		  return;}
	     }
	  }
       }
      #couldn't find a (satisfacory) solution with subnets, store it as a link
      {if ($data1->[9])
	 {unless (grep {$_ eq $second} @{$data1->[9]})
	    {push @{$data1->[9]},$second}}
       else
	 {$data1->[9]=[$second]}}
    }
 }

sub add_ip_to_subnet
  {my($ip,$subnetid)=@_;
   my $data=$IPdata{$ip};
   my $s=$Subnet[$subnetid];

   if(!$data)
     {log_message(1,"Adding unknown IP ".&l2d($ip)." to ".&ss($s));
      return;}
   #updatig structures
   $data->[6]=$subnetid;
   if($s->[3])
     {unless(grep {$_ eq $ip} @{$s->[3]})
       {push @{$s->[3]},$ip}}
   else
     {$s->[3]=[$ip]}
   #updating skew data
   if ($data->[3] ne '' and $data->[4] ne '')
     {my $skew=$data->[3]-$data->[4];
      if($s->[5] ne '' and $s->[5] != $skew)
	{log_message(3,"Skew jitter from $s->[5] to $skew for ".&l2d($ip).
		     " and ".&ss($s))}
      $s->[5]=$skew;
    }
   if($data->[5])#update lasthop data
     {if(!$s->[4])
	{$s->[4]=[$data->[5]]}
      elsif(!grep {$_ eq $data->[5]} @{$s->[4]})
	{push @{$s->[4]},$data->[5]}
    }
   #update delays here
   my ($delay) = $data->[2];
   return if (!$delay);

   $s->[6] = $delay if ($delay < $s->[6]);
   $s->[7] = $delay if ($delay > $s->[7]);
   $s->[8] += $delay;
   $s->[9]++;
 }

sub add_gw_to_subnet
  {my($ip,$subnetid)=@_;
   my $data=$IPdata{$ip};
   my $s=$Subnet[$subnet];

   if(!$data)
     {log_message(1,"Adding unknown IP ".&l2d($ip)." to ".&ss($s));
      return;}
   $data->[6]=$subnetid;
   if($s->[3])
     {unless(grep {$_ eq $ip} @{$s->[3]})
	{push @{$s->[3]},$ip}}
   else
     {$s->[3]=[$ip];}
 }

#Takes two IP addresses that just got correlated by a traceroute and takes
#care of them
sub correlate
  {my($close,$dest)=@_;

   if(not($IPdata{$close} and $IPdata{$dest}))
     {log_message(1,"Cannot correlate addresses without IPdata ".
		 &l2d($close)." ".&l2d($dest));}
   my($datac)=$IPdata{$close};
   my($datad)=$IPdata{$dest};
   my($router)=get_common_router($close,$dest);
   if(!$router){return;}
   my(@links)=@{$datac->[9]};
   #Tada!!!!!!!
   $datac->[9]='';
   my ($link);
   foreach $link (@links)
     {&store_link($datac->[3],$close,$link);}
   #Maybe it's a little slow, but it's easy to write :-)
 }

#Return the router to which 2 IP addresses belong. If there is no such thing,
#create one.
sub get_common_router
  {my($close,$dest)=@_;
   my($router,$x);
   
   $router=($IP2router{$close} or '');
   $x=($IP2router{$dest} or '');

   if($router ne '')
     {if ($x ne '')
	{if ($x eq $router)
	   {return $router}
	 else
	   {log_message(1,"Cannot correlate addresses ".&l2d($close)." and ".
			&l2d($dest)." belonging to different routers ".
			&pr($router).&pr($x));
	  return '';}}
      else
	{$IPdata{$dest}->[8]=$router;
	 $IP2router{$dest}=$router;
	 push @{$Router[$router]->[0]},$dest;
	 $Router[$router]->[2].=(";Correlated_".&l2d($dest));
	 return $router;}
    }
   else
     {if ($x ne '')
	{$IPdata{$close}->[8]=$x;
	 $IP2router{$close}=$x;
	 push @{$Router[$x]->[0]},$close;
	 $Router[$x]->[2].=(";Correlated_".&l2d($close));
	 return $x;}
    }
   #Creating new router 
   $router=[[$close,$dest],
	    1,
	    "Correlation_".&l2d($close)."_".&l2d($dest)];
   push @Router,$router;
   $router=$#Router;
   $IP2router{$close}=$router;
   $IP2router{$dest}=$router;
   $IPdata{$close}->[8]=$router;
   $IPdata{$dest}->[8]=$router;
   return $router;
 }

#Input: an address and a name
#Output: whether it is in the domain that's currently discovered (in limits)
sub is_interesting {
  my ($ip,$name)=@_;
  my $subnet;

  if (!$name){
    if ($strictdns) {return '';}
   } else {
     my $i;
     for ($i=0;$i<=$#ctx_dns_limit;$i++) { 
       last if ($name =~ /\.$ctx_dns_limit[$i]$/);
       last if ($name eq $ctx_dns_limit[$i]);
       last if ($ctx_dns_limit[$i] eq '');
#       log_message (5, "Namenotinterest >$name< domain >$ctx_dns_limit[$i]<");
     }
     if ($i>$#ctx_dns_limit) {return '';}
   }

   foreach $subnet (@ctx_ip_limit){
     return '1' if (("$ip" & "$subnet->[1]") eq $subnet->[0]);
#     log_message(5,"IPnotinteresting ".&l2d($ip)." net ".&l2d($subnet->[0]).
#		 " mask ".&l2d($subnet->[1])." and ".
#		 &l2d("$ip" & "$subnet->[1]"));
   }
    return '';
 }


#Input: a subnet IP + netmask
#Output: the list of the ids of the overlapping subnets
sub overlapping_subnets
  {my ($net,$mask)=@_;
   my ($i,@result);
   
   for (($i,@result)=(0); $i<=$#Subnet; $i++)
     {next unless ($Subnet[$i]);
      my ($smaller)=&more_specific_3($mask,$Subnet[$i]->[1]);
      if ($smaller == -1) #mask more specific
	{push (@result,$i) if (($net & $Subnet[$i]->[1])eq $Subnet[$i]->[0])}
      elsif ($smaller == 1)#subnet[i] more specific
	{push (@result,$i) if ($net eq ($Subnet[$i]->[0] & $mask))}
      else #masks equal
	{push (@result,$i) if ($net eq $Subnet[$i]->[0])}
    }
   return (@result);
 }

sub create_if_possible
  {my ($net,$mask)=@_;
   my (@overlap);

   @overlap=&overlapping_subnets($net,$mask);
   if ($#overlap<0)
     {return &create_subnet($net,$mask);}
   elsif ($#overlap == 0)
     {if ($mask eq $Subnet[$overlap[0]]->[1])
	{return $overlap[0];}
      elsif (&more_specific($Subnet[$overlap[0]]->[1],$mask))
	{if (&extend_netmask($Subnet[$overlap[0]],$mask))
	   {return $overlap[0];}
	 else
	   {return '';}
       }
      else
	{&log_message(3,"Cannot shrink subnet".
		      &serialize('Subnet',$Subnet[$overlap[0]]).
		      " to ".&long2dotted($mask));
	 return '';}
    }
   else
     {return &combine_subnets($net,$mask,\@overlap);}
 }

sub combine_subnets
  {my ($net,$mask,$list)=@_;
   my ($id);

   if($#$list<1)
     {&log_message(1,"Attempt to combine too few ($#$list+1) subnets into ".
		   &long2dotted($net)."/".&long2dotted($mask));
      return &create_subnet($net,$mask);
    }
   foreach $id (@$list)
     {&extend_netmask($Subnet[$id],$mask);}
   $target=shift @$list;
   foreach $id (@$list)
     {&move_all_computers($id,$target);}
   foreach $id (@list)
     {$Subnet[$id]=''}
   return $target;
 }

sub create_subnet
#Should check for empty slots left by deleted subnets....
  {my ($net,$mask)=@_;

   push @Subnet,[$net,$mask,$ctx_subnet_method, 0, 0, 0, 10000000, 0, 0, 0];
   return $#Subnet;
 }

sub extend_netmask
  {my ($subnet,$mask)=@_;

   if ($ctx_subnet_method<$subnet[2])
     {return '';}
   if ($ctx_subnet_method==$subnet[2] and $ctx_subnet_method==1)
     {&log_message(2,"SNMP subnet inconsistency:".&long2dotted($subnet->[0]).
		   " extended from ".&long2dotted($subnet->[0])." to ".
		   &long2dotted($mask));}
   $subnet->[0]=($mask & $subnet->[0]);
   $subnet->[1]=$mask;
   return 1;
 }


#Input: a router IP (in long format) and SNMPdata
#Output: the id of the router
sub add_snmp_data
  {my($router,$data)=@_;
   my($id,@oldip,@newip,@oldsubn,@newsubn,$n,$i,$newlist);
   local($ctx_subnet_method)=1;

   unless ($id=&store_computer($router)) {return ''}
   @oldip=sort @{$Computer[$id]->[0]};
   @newip=sort (map {$_->[0]} @{$data->[3]});
   @newip=grep {$_ ne $LOCALHOST} @newip;
   unless (grep {$router eq $_} @newip)
     {&log_message(1, "Router address ".&long2dotted($router).
		   " is not in ".&serialize('SNMPdata',$data));
      return ''}
   $newlist=[];
   #check IP addresses

   for (($i,$n)=(0,0);$i<=$#oldip and $n<=$#newip;)
     {if($oldip[$i] eq $newip[$n])
	{ push @$newlist,$newip[$n];
	 $i++;$n++;}
      elsif($oldip[$i] lt $newip[$n])
	{&log_message(3,"Extra IP address ".&long2dotted($oldip[$i]).
		      " found in router $Computer[$id]->[1]->[0]");
	 undef $IP2Comp{$oldip[$i]};
	 $i++;}
      else
	{&log_message(3,"IP address ".&long2dotted($newip[$n]).
		      " not found in router $Computer[$id]->[1]->[0]");
	 $IP2Comp{$newip[$n]}=$id;
	 push @$newlist,$newip[$n];
	 $n++;}
    }
   while ($i<=$#oldip)
     {&log_message(3,"Extra IP address ".&long2dotted($oldip[$i]).
		      " found in router $Computer[$id]->[1]->[0]");
      undef $IP2Comp{$oldip[$i]};
      $i++;}
   while($n<=$#newip)
     {&log_message(3,"IP address ".&long2dotted($newip[$n]).
		      " not found in router $Computer[$id]->[1]->[0]");
      $IP2Comp{$newip[$n]}=$id;
      push @$newlist,$newip[$n];
      $n++;}
   $Computer[$id]->[0]=$newlist;

   #check subnets
   @newip=map ({[($_->[0] & $_->[1]),$_->[1]]} @{$data->[3]});
   @newsubn=();
   foreach $i (@newip)
     {if($n=&create_if_possible($i->[0],$i->[1]))
	{push @newsubn,$n}
    }
   if ($#newsubn <0)
     {&log_message(2, "No suitable subnets in SNMPdata ".
		   &serialize('SNMPdata',$data));
      return ''}
   elsif ($#newsubn == 0)
     {my ($comp);
      $comp=$Computer[$id];
      if($comp->[2])
	{$comp->[2]->[0]=$newsubn[0];}
      elsif($comp->[3])
	{$comp->[3]->[0]=[$newsubn[0]];}
      else
	{&log_message(1,"Bad computer structure:".
		      &serialize('Computer',$comp));}
    }
   else
     {my ($comp);
      $comp=$Computer[$id];
      if($comp->[2])
	{&convert_host_to_router($comp);}
############## TOTALLY WRONG!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      @oldsubn=sort (@{$comp->[3]->[0]});
      @newsubn=sort @newsubn;
      $newlist=[];
      for (($i,$n)=(0,0);$i<=$#oldsubn and $n<=$#newsubn;)
	{if($oldsubn[$i] eq $newsubn[$n])
	   {$i++;$n++;
	    push (@$newlist,$newsubn[$n]);
	  }
	 elsif($oldsubn[$i] lt $newsubn[$n])
	   {&log_message(3,"Extra subnet ".&long2dotted($oldsubn[$i]).
			 "found in router $comp->[1]->[0]");
	    $i++;
	  }
	 else
	   {&log_message(3,"Subnet ".&long2dotted($newsubn[$n]).
			 " not found in router $comp->[1]->[0]");
	    push (@$newlist,$newsubn[$n]);
	    $n++;
	  }
       }
      while($i<=$#oldsubn)
	{&log_message(3,"Extra subnet ".&long2dotted($oldsubn[$i]).
		      " found in router $comp->[1]->[0]");
	 $i++;
       }
      while($n<=$#newsubn)
	{&log_message(3,"Subnet ".&long2dotted($newsubn[$n]).
		      " not found in router $Computer[$id]->[1]->[0]");
	 push (@$newlist,$newsubn[$n]);
	 $n++;
       }
############## TOTALLY WRONG ends here.
      $comp->[3]->[0]=$newlist;
    }
   if ($Computer[$id]->[3])
     {push @SNMPdata,$data;
      $Computer[$id]->[3]->[2]=$#SNMPdata;
    }
   else
     {&log_message(3,"It's unusual to get SNMP data from a non-router".
		  &serialize('Computer',$Computer[$id]))}
   return $id;
 }

################# Unnused stuff below this line

#Input: the ids of the source and destination subnet
#Moves all computers to the new subnets, updating their subnet field too
sub old_move_all_computers
  {my ($src,$dest)=@_;
   my ($ip);

   foreach $ip (@{$Subnet[$src]->[3]})
     {my ($comp,$i);
      $comp=$Computer[$IP2Comp{$ip}];
      if($comp->[2])
	{$comp->[2]->[0]=$dest;}
      elsif($comp->[3])
	{for ($i=0;$i<=$#{$comp->[3]->[0]};$i++)
	   {if($comp->[3]->[0]->[$i] eq $src)
	      {$comp->[3]->[0]->[$i]=$dest;
	       last;}
	  }
       }
      else
	{&log_message(1,"Bad computer structure:".&serialize('Computer',$comp));}
    }
   push @{$Subnet[$dest]->[3]},@{$Subnet[$src]->[3]}
  }


return 1;
