#functions for interfacing thr workers with the topology
#database. Interactions with workers are in dotted format and with the
#database in the internal format. All dealings with %Visited (which ia
#indexed by the dotted form of the IP addresses) within the central
#process happen in this file.

sub remote_check_visited{
  return remoteinvoke('DBCONNECTION','check_visited',@_);
}
sub remote_store_computers{
  return remoteinvoke('DBCONNECTION','store_computers',@_);
}
sub remote_store_computers_h6{
  return remoteinvoke('DBCONNECTION','store_computers_h6',@_);
}
sub remote_process_router_hints{
  return remoteinvoke('DBCONNECTION','process_router_hints',@_);
}
sub remote_report_dead{
  return remoteinvoke('DBCONNECTION','report_dead',@_);
}
sub remote_report_subdomains{
  return remoteinvoke('DBCONNECTION','report_subdomains',@_);
}
sub remote_report_ip_class{
  return remoteinvoke('DBCONNECTION','report_ip_class',@_);
}
sub remote_unvisited_routers{
  return remoteinvoke('DBCONNECTION','unvisited_routers',@_);
}
sub remote_store_paths{
  return remoteinvoke('DBCONNECTION','store_paths',@_);
}
sub remote_UpdateRtt {
    return remoteinvoke('DBCONNECTION', 'UpdateRtt', @_);
}
sub remote_hist_gen {
    return remoteinvoke('DBCONNECTION', 'hist_gen', @_);
}
sub remote_is_interesting {
  return remoteinvoke('DBCONNECTION','is_interesting_dotted',@_);
}

sub is_interesting_dotted {
  my ($ip,$name)=@_;
  return &is_interesting(dotted2long($ip),$name);
}

sub UpdateRtt {
    my ($rtt) = @_;

    $g_nHostPinged++;
    $g_nTotRtt += $rtt;
    $g_nMaxRtt = $rtt if ($rtt > $g_nMaxRtt);
    $g_nMinRtt = $rtt if ($rtt < $g_nMinRtt);
}

#Input: list with IP addresses of candidates to piging, DNS  and tracing
#Output: timeout to be used for ping + list of addresses
sub check_visited
  {my (@candidates)=@_;
   my ($ip,$timeout,@result);

   if ($g_nHostPinged < 20 or $noadaptivetimeout) {
       $timeout = $g_nDefaultPingTimeout;
     } else {
     my ($avg)=($g_nTotRtt / $g_nHostPinged);
     $timeout = int(($avg + ($avg - $g_nMinRtt)* 2));
     log_message (5,"@@ timeout = $timeout @@ avg = $avg @@");
   }

#   $timeout = 100;
#   $timeout=50; ############### Magic number to be replaced with smart code
   @result=();
   foreach $ip (@candidates)
     {my $status=($Visited{$ip} or 0);
	{unless ($status==1 or $status==3 or $status==4 or $status==5)
	   #if it is only alive(2) we visit it again so it gets traced
	   {push @result,$ip;}}
    }
   return ($timeout,@result);
}

#Input: list with IP addresses of candidates to piging and DNS (no tracing)
#Output: timeout to be used for ping + list of addresses
sub unvisited_routers
  {my (@candidates)=@_;
   my ($ip,$timeout,@result);

   if ($g_nHostPinged < 20 or $noadaptivetimeout) {
       $timeout = $g_nDefaultPingTimeout;
   } else {
     my ($avg)=($g_nTotRtt / $g_nHostPinged);
     $timeout = int(($avg + ($avg - $g_nMinRtt)* 2));
     log_message (5,"@@ timeout = $timeout !! avg = $avg @@");
   }

   @result=();
   if($useSNMP) {&add_unique(\@jq_router,\%inq_router,\@candidates)}
   foreach $ip (@candidates) {
     if(!$Visited{$ip}) {push @result,$ip;}
   }
   return ($timeout,@result);
 }

#A worker is reporting dead computers so that %Visited gets updated in
#the central process too.
#note: we do not delete the IPdata of a computer that was live, but deceased
sub report_dead {my $i; foreach $i (@_){$Visited{$i}=3}}

#A worker is reporting the new subdomains that it found
sub report_subdomains {
  &add_unique (\@jq_domain,\%inq_domain,\@_);
  &give_jobs; #In single process mode this doesn't do a thing because "there
              #are no more idle workers"
}

#A worker is reporting new (class C) networks to probe
sub report_ip_class { 
  add_unique (\@jq_ip,\%inq_ip,\@_);
  &give_jobs;
}

#Adds elements to a list if it's not already in there
sub add_unique {
  my ($plist,$phash,$pnewlist)=@_;
  my ($item);

  foreach $item (@$pnewlist) {
    next if ($$phash{$item});
    $$phash{$item}=1;
    push @$plist,$item;
  }
}

#Input: a list of lists with information about pinged computers
#Output: a list of IPs and minttls for traceroute
#The ones that get droped from the result are uninteresting or already
#tracerouted to (which can happen only with multiple workers).
sub store_computers {
  my (@comp)=@_;
  my ($node,@list,@result,$data,$status,$i,$newjobs);
  
  @list=();
  $newjobs=0;
  foreach $node (@comp){
    my @dbnode=(&dotted2long($node->[0]),$node->[1],$node->[2]);
    if($node->[3]) {
      push @dbnode,$node->[3];
      push @dbnode,(map {&dotted2long($_)} @$node[4..$#$node]);
    }
    if($data=store_IPdata(@dbnode)){
      my ($status)=($Visited{$node->[0]} or 0);
      if ($status == 4){
	log_message(4,"Traced IP visited again ".&si($data));
      } else {
	$Visited{$node->[0]}=2;
      }
      push @list,[$node->[0],$data];
      #let's check if we found a new domain
      unless ($nodns) {
	my ($name)=$node->[3] or '';
	if ($name) {
	  my ($domain);
	  $name =~ /^([\da-z\-]+)\.([a-z\d\-\.]+)$/;
	  $domain=$2;
	  unless ($inq_domain{$domain}) {#the domain is not in the job queue
	    for ($i=0;$i<=$#ctx_dns_limit;$i++) {#if it's within limits
	      if ($domain =~ /\.$ctx_dns_limit[$i]$/ or
		  $domain eq $ctx_dns_limit[$i] or
		  $ctx_dns_limit[$i] eq '') {
		push @jq_domain, $domain;
		$inq_domain{$domain}=1;
		$newjobs=1;
	      }
	    }
	  }
	}
      }
    } else {#Outsidedomain
      $Visited{$node->[0]}=5;
    }

  }
  @result=();
  foreach $data (@list){
    my ($min_ttl)=&compute_minttl($data->[1]);
    if ($min_ttl){
      push @result,[$data->[0], $min_ttl]
    }
  }
  if ($newjobs) {
    &give_jobs;#In single process mode this doesn't do a thing because "there
               #are no more idle workers"
  }
  return @result;
}

#Input: a list of lists with information about pinged computers
#Output: a list of IPs and minttls for traceroute
#The ones that get droped from the result are uninteresting or already
#tracerouted to (which can happen only with multiple workers).
sub store_computers_h6 {
  my (@comp)=@_;
  my ($node,@list,@result,$data,$status,$i,$newjobs,$ip);
  
  @list=();
  $newjobs=0;
  foreach $node (@comp){
    my @dbnode=(&dotted2long($node->[0]),$node->[1],$node->[2]);
    if($node->[3]){
      push @dbnode,$node->[3];
      push @dbnode,(map {&dotted2long($_)} @$node[4..$#$node]);
    }
    if($data=store_IPdata(@dbnode)){
      my ($status)=($Visited{$node->[0]} or 0);
      if ($status == 4){
	log_message(4,"Traced IP visited again ".&si($data));
      } else {
	$Visited{$node->[0]}=2;
      }
      push @list,[$node->[0],$data];
      #let's check if we found a new domain
      unless ($nodns) {
	my ($name)=$node->[3] or '';
	if ($name) {
	  my ($domain);
	  $name =~ /^([\da-z\-]+)\.([a-z\d\-\.]+)$/;
	  $domain=$2;
	  unless ($inq_domain{$domain}) {#the domain is not in the job queue
	    for ($i=0;$i<=$#ctx_dns_limit;$i++) {#if it's within limits
	      if ($domain =~ /\.$ctx_dns_limit[$i]$/ or
		  $domain eq $ctx_dns_limit[$i] or
		  $ctx_dns_limit[$i] eq '') {
		push @jq_domain, $domain;
		$inq_domain{$domain}=1;
		$newjobs=1;
	      }
	    }
	  }
	}
      }
      #let's see whether we have new IP addresses
      foreach $ip ($node->[0],@$node[4..$#$node]) {
	if (&check_IP_h6($ip)) {$newjobs=1;}
      }
    } else {#Outsidedomain
      $Visited{$node->[0]}=5;
    }
  }
  @result=();
  foreach $data (@list){
    my ($min_ttl)=&compute_minttl($data->[1]);
    if ($min_ttl){
      push @result,[$data->[0], $min_ttl]
    }
  }
  if ($newjobs) {
    &give_jobs;#In single process mode this doesn't do a thing because "there
               #are no more idle workers"
  }

#Check DNS name first and if it is OK, check IP addresses
#If it came up with anything new
  &give_jobs; 
  return @result;
}

#This function checks whether h6 already recommended a prefix covering
#this address or not. It returns '' if this address is covered or
#outside the domain of interest and 1 if this address had the effect
#of extending the h6 prefix collection
sub check_IP_h6 {
  my ($addr)=@_;
  my ($laddr,$prefix);

  $laddr=dotted2long($addr);
  foreach $prefix (@h6_prefixes) { #check if it's covered
    my ($paddr,$pmask)=@$prefix;
    return '' if (("$laddr" & "$pmask") eq $paddr); #covered
  }
  foreach $prefix (@ctx_ip_limit) {
    my ($paddr,$pmask)=@$prefix;
    if (("$laddr" & "$pmask") eq $paddr) {#it's legal, we have to
                                          #extend h6_prefixes
      my ($candidateip,$candidatemask);
      $candidatemask=h6_proper_mask($addr);
      if (more_specific($candidatemask,$pmask)) {
	$candidateip="$laddr" & "$candidatemask";
#	add_prefix_to_h6($candidateip,$candidatemask);
########!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#Here I should check whether I can combine the prefix with others
	push @h6_prefixes, [$candidateip,$candidatemask];
      } else {
	$candidateip="$laddr" & "$pmask";
	push @h6_prefixes, [$candidateip,$candidatemask=$pmask];
      }
      #now generate all C classes that need be probed
      push @pjq_prefix,[&l2d($candidateip),&l2d($candidatemask)];
      return 1;
    } 
  }
  return ''; #outside limits
}

#This function decides the size of the ip address prefix that will be
#checked upon the discovery of an uncovered address.
sub h6_proper_mask {
  my ($addr)=@_;

  $addr =~ /^(\d+)\./;
  if ($1>=192) { #class C zone
    if ($persistance_factor<2) {
      return $MASK24;
    } elsif ($persistance_factor == 2) {
      return $MASK22;
    } else { 
      return $MASK20;
    }
  } elsif ($1>=128) { #class B zone
    if ($persistance_factor<2) {
      return $MASK22;
    } elsif ($persistance_factor == 2) {
      return $MASK19;
    } else { 
      return $MASK16;
    }
  } else { #class A zone
    if ($persistance_factor<2) {
      return $MASK20;
    } elsif ($persistance_factor == 2) {
      return $MASK16;
    } else { 
      return $MASK12;
    }
  }
}

#this one should be improved.....
sub compute_minttl{
  my ($data)=@_;
  return ($data->[4]<3?1:($data->[4]-1));
}

#Input: a list of router hints for address correlation
#(name,addr1,addr2,...) in dotted format
sub process_router_hints{
  my (@hints)=@_;
  my $hint;
  
  foreach $hint (@hints){
    process_router_hint($hint->[0],
			(map {dotted2long($_)} @$hint[1..$#$hint]));
  }
}

#Input: a bunch of traceroute paths - dest, status, last TTL, hops
############!!!!!!! ignoring successful traceroute to just the endpoint.
################### have to fix this
sub store_paths
  {my (@paths)=@_;
   my ($path,$i,$lastrouter,$data);

   local($ctx_subnet_method)=0;#guessing subnets

   foreach $path (@paths)
     {my $dest=&dotted2long($$path[0]);
      my $status=$$path[1];
      my $lastttl=$$path[2];
      my @hops=map {&dotted2long($_)} @$path[3..$#$path];
      my $firstttl=$lastttl-$#hops;

      if ($status eq 'OK') {$lastrouter=$#hops-1}
      else {$lastrouter=$#hops}
      #store stuff that's on the path
      for ($i=0;$i<$lastrouter;$i++)
	{if($hops[$i] eq $hops[$i+1])
	   {log_message(3,"Looping router ".$$path[$i+3]." for destination ".
			$$path[0]);
	    last;}
	 else
	   {&store_link($firstttl+$i,$hops[$i],$hops[$i+1])}
       }
      #handle destination
      $data=($IPdata{$dest} or '');
      if(!$data)
	{log_message(1,"Traceroute to unknown address ".$$path[0]);
	 next;}
      if($status eq '*' or $hops[$i] eq $hops[$i+1])
	{unless ($data->[5] and $data->[5] ne $NO_SUCH_COMPUTER)
	   {$data->[5]=$NO_SUCH_COMPUTER}}
      else
      {
	  my $lasthop=($#hops>0?$hops[$#hops-1]:'');
	  my $traceip=$hops[$#hops];
	  if($#hops<0)
	  {log_message(2,"Traceroute not OK with 0 hops to address ".
		       $$path[0]);
	   next;}
	  &store_link($lastttl-1,$lasthop,$traceip,$dest);
      }
      $Visited{$$path[0]}=4;
    }
 }



return 1;
