#functions that manage all interaction between the in-memory database
#and the disk 

#Input: the name of the database directory
#Output: the name of the database directory (one is invented if none given)
sub database_init {
  my($dir)=@_;

  if (!$dir) {
    my ($sec,$min,$hour,$mday,$mon,$year)=localtime(time);
    $year+=1900;
    $mon++;
    $dir=sprintf("database-$year.%02u.%02u.%02u.%02u",
		 $mon,$mday,$hour,$min);
  }
  if  (! -d $dir ){
    mkdir ($dir,0755) or die "Cannot create database directory $dir";
  }
  return $dir;  
}

sub write_db
  {my ($database)=@_;

   log_message(4,"Writing out database $database");
   write_out_objects ($database,'Router','Subnet','SNMPdata');
   write_out_hashes ($database,'IPdata');
 }

sub write_out_objects
  {my ($database,@files)=@_;
   my ($file,$i);

   foreach $file (@files)
     {log_message(4, "Writing $#$file objects to $file");
      open (DATABASEFILE,">$database/$file");
      for ($i=0;$i<=$#$file;$i++)
	{print DATABASEFILE $i.&serialize($file,$$file[$i]); 
	 print DATABASEFILE "\n";
       }
      close DATABASEFILE;
      log_message (4,"Done with $file in database $database");
    }
 }

############## doesn't work for 'n' type hash structures 
sub write_out_hashes
  {my ($database,@files)=@_;
   my ($file,$key,$keytype,$datatype);

   foreach $file (@files)
     {my (@keys)=keys %$file;
      $keytype=$Hash{$file}->[0];
      $datatype=$Hash{$file}->[2];
      log_message(4,"Writing $#keys items to $file");
      open (DATABASEFILE,">$database/$file");
      foreach $key (@keys)
	{print DATABASEFILE &serialize($keytype,$key)." ".
	   &serialize($datatype,${$file}{$key} )."\n";
       }
      close DATABASEFILE;
      log_message(4,"Done with $file in database $database");
     }
 }

return 1;
