
sub h5_checker
  {my ($timeout,@addrs)=@_;
   my ($livehosts,$ttl,$rtt,@comp,$i,$n,@alive,@accepted,@temp);

   $n = @addrs;
   if($#addrs<0)
     {return;}

   ($result,$ttl,$rtt)=&bping_alive($timeout,@addrs);
   @comp=();
   $livehosts=0;
   for ($i=0;$i<@addrs;$i++) {
       if ($$result[$i] == 0) {
	   my $ip=$addrs[$i];
	   my ($name,$node);

	   &$ctx_UpdateRtt($$rtt[$i]) unless ($$rtt[$i] eq '');
	   $node=[$ip,$$ttl[$i],$$rtt[$i]];
	   unless ($name=$ip2name{$ip})
	   {$name=&dns_addr2name($ip)}
	   if ($name) {
	       my (@otherips);
	       push @$node,$name;
	       @otherips=&dns_name2addrs($name);
	       push (@$node,(grep {$ip ne $_} &dns_name2addrs($name)));
	   }
	   push (@comp,$node);
	   push (@alive,$addrs[$i]);
	   $livehosts++;
       } else {
	   push (@$ctx_dead,$addrs[$i]);
       }
    }

   &log_message(4,"---$ctx_info--- checked $n, $livehosts alive");

   @temp=&$ctx_store_computers(@comp);
   @accepted= (map {$_ -> [0]} @temp);
   push (@$ctx_alive,@accepted);
   push (@$ctx_outside,
	 (map {my ($ip)=$_; if(!grep{$ip eq $_}@accepted){$ip}else{()};}
	  @alive)); #the ones alive, but not accepted

   if ($do_traceroutes) {
       &do_traces($timeout, @temp);
   }
 }

#sub fake_store_computers
#{my (@comp)=@_;
#   my $i;
#
#print ">>> $#comp\n";
#   for ($i=0;$i<=$#comp;$i++)
#     {print (join (' ',@{$comp[$i]}));
#      print "\n";
#      ${$comp[$i]}[1]=3; #set TTL
#    }
#   return @comp;
# }

sub do_traces {
    my ($timeout, @jobs)=@_;
    my ($i,@traces,@routers,$trace);

#    $timeout = int($timeout*1.0);

    #do the traces
    for ($i=0;$i<@jobs;$i++) {
      $traces[$i]=&tracert(${$jobs[$i]}[0],$timeout,${$jobs[$i]}[1]);
    }

#print ((join (' ',@{$traces[$i]})));
#print " -> ${$jobs[$i]}[0]";
#print"\n";

#It's better to have the routers in the database when storing the traces
   @routers=();
   foreach $trace (@traces)
     {my ($router,$status);
      my (@hops)=@{$trace};
      $status=shift @hops;
      shift @hops;
      foreach $router (@hops)
	{unless (grep {$router eq $_} @routers)
	   {push (@routers,$router)}
       }
     }
#print "------------ ";
#print join (' ',@routers);
#print "\n";
#we ask whether the routers are already in the database
   ($timeout,@routers)=&$ctx_unvisited_routers(@routers);
   #discover the ones that aren't in the database
   {local ($do_traceroutes)='';
    h5_checker($timeout,@routers); 
    #Some of them happen not to answer to the ping - so the won't be inserted
    #into the database. This results in a stupid error message and the culprit
    #gets pinged again with the next batch. No big deal.
  }
   #store the paths
   for ($i=0;$i<@jobs;$i++)
     {unshift @{$traces[$i]},${$jobs[$i]}[0]}
   &$ctx_store_paths(@traces);
}

return 1;

