#!/usr/u/cnrg/bin/perl

#use strict 'refs';
use Getopt::Long;

&GetOptions('targetdns:s'=>\@ctx_dns_target,
	    'targetip:s'=>\@ctx_ip_target,
	    'limitdns:s'=>\@ctx_dns_limit,
	    'limitip:s'=>\@ctx_ip_limit,
	    'strictdns'=>\$strictdns,
	    'database:s'=>\$database,
	    'children:i'=>\$nworkers,
	    'identity:s'=>\$identity,
	    'aggressiveness:i'=>\$aggressiveness,
	    'nodns'=>\$nodns,
	    'nodnslisting'=>\$nodnslisting,
	    'defaulttimeout:i'=>\$defaulttimeout,
	    'noadaptivetimeouts'=>\$noadaptivetimeout,
	    'historyfile:s'=>\$historyfile,
	    'useSNMP'=>\$useSNMP,
	    'SNMPcommunity:s@'=>\@communities,
	    'compressresults'=>\$compressresults,
	    'eyecomputer:s'=>\$eyecomputer,
	    'eyeport:i'=>\$eyeport,
	    'eyepassword:s'=>\$eyepassword,
	   );

#need this for the external multiprocess case where workers have to be
#started up in separate direcories so that they can be profiled each
if ($identity =~ /^worker(\d+)$/) {
  chdir '..'
} elsif ($identity and $identity !~ /^central$/) {
  die "Identity should be either central or worker1, worker2, etc. ";
}

#now we are for sure in the argus directory, so we can include the goodies
require 'inet.pl';
require 'dbstructure.pl';
require 'dbdisk.pl';
require 'dboperations.pl';
require 'dbinterface.pl';
require 'logging.pl';
require 'parallel.pl';
require 'ping.pl';
require 'tracert.pl';
require 'dns.pl';
require 'checker.pl';
require 'ipmaker.pl';
require 'h5.pl';
require 'h5-generator.pl';
require 'h4-generator.pl';
require 'h6-generator.pl';
require 'serializer.pl';
require 'shorties.pl';
require 'init.pl';
require 'history.pl';
require 'brain.pl';

#my @aaa=(&d2l('255.255.8.0'),&d2l('255.255.0.0'),&d2l('255.255.224.0'),
#	 &d2l('255.192.0.0'),&d2l('255.255.255.0'),&d2l('255.255.252.0'),
#	 &d2l('255.255.255.248'),&d2l('255.255.248.0'),&d2l('255.255.128.0'),
#	 &d2l('255.255.254.0'),&d2l('255.255.255.255'),&d2l('255.255.255.240'),
#	 &d2l('255.255.255.192'),&d2l('255.255.255.224'),&d2l('255.255.255.0'),
#	 &d2l('255.255.255.224'),&d2l('255.255.255.128'),&d2l('255.255.192.0'),
#	 &d2l('255.255.255.0'),&d2l('255.255.255.0'),&d2l('255.255.255.128'));
#for ($i=1;$i<1000;$i++) {
#  foreach $a (@aaa) {
#    foreach $b (@aaa) {
#      if (more_specific($a,$b)) {
#	$c++;
#      }
#    }
#  }
#}
#print "$c\n";
#exit;
#processing the options

if (!@ctx_dns_limit) {
  if (@ctx_dns_target) {
    @ctx_dns_limit=@ctx_dns_target;
  } else {
    @ctx_dns_limit=(''); #accept any name
  }
}

if (!@ctx_ip_limit) {
  if (@ctx_ip_target) {
    @ctx_ip_limit=@ctx_ip_target;
  } else {
    @ctx_ip_limit=('0.0.0.0/0.0.0.0'); #accept any IP
  }
}
#convert ctx_ip_limit to internal format
my $i;
for ($i=0;$i<@ctx_ip_limit;$i++) {
  $ctx_ip_limit[$i]=~/([\d\.]+)\/([\d\.]+)/ or
    die "Malformed ip target option $ctx_ip_target[$i]";
  my($txtip,$txtmask)=($1,$2);
  my($ip,$mask);
  $ip=&d2l($txtip) or die "Invalid IP address $txtip";
  unless ($mask=&d2l($txtmask)) {#mask not in dotted format
    $mask=&cidr2long($txtmask);
  }
#print (&l2d($ip),' ',&l2d($mask)," $i\n");
  $ctx_ip_limit[$i]=[$ip,$mask];
}
#die;
if (@ctx_ip_target) { #split at / and convert from CIDR netmasks to dotted
  my ($i,$ip,$mask);
  for ($i=0;$i<@ctx_ip_target;$i++) {
    $ctx_ip_target[$i] =~ /([\d\.]+)\/([\d\.]+)/ or 
      die "Invalid IP target $ctx_ip_target[$i]";
    $ip=$1;
    $mask=$2;
    if ($mask !~ /\d+\.\d+\.\d+\.\d+/) {$mask=l2d(cidr2long($mask));}
    $ctx_ip_target[$i]=[$ip,$mask];
  }
}

#Job queues - jobs are done by workers
@jq_hist=();#jobs based on history information (collectd by other runs)
@jq_domain=();#domains we have to work on
@jq_ip=();#IP addresses (each standing for its C class
@jq_router=();#Possible routers that might be SNMPed
#and their hashes and counters (indexes)
%done_hist=();
$crt_hist=0;
%inq_domain=();
%done_domain=();
$crt_domain=0;
%inq_ip=();
%done_ip=();
$crt_ip=0;
%inq_router=();
%done_router=();
$crt_router=0;
#Pre-job queues - pre-jobss are used by the central process to
#generate jobs
@pjq_prefix=();#prefixes that can be used to generate IPs to be probed
@pjq_h2=();#traceroutes to the target to find routers to interrogate by SNMP


add_unique (\@jq_domain,\%inq_domain,\@ctx_dns_target) unless ($nodns);
@h6_ip_prefixes=();
@h6_domains=();

if (@ctx_ip_target) {
  push @pjq_prefix, @ctx_ip_target;
}

if ($useSNMP) {
  my (@seeds)=map {$_->[0]} @ctx_ip_target;
  add_unique(\@jq_router,\%inq_router,\@seeds);
  @seeds= map "www.$_",@ctx_dns_target;
  add_unique(\@jq_router,\%inq_router,\@seeds);
}

if ($nworkers>0)
  {&init_forked()}

if ($nworkers>0)
  {&init_forked()}
if ($identity) {
  if($identity eq central) {
    &init_external_central;
    &central_main;
  } else {
    &init_external_worker;
    &worker_main;
  }
  
}

&init_single;

#h6_gen($ctx_dns_target[0]);

#&finish;

#exit;

while (@jq_hist> keys %done_hist or
       @jq_domain> keys %done_domain or
       @pjq_prefix>0 or
       @jq_ip> keys %done_ip) {
#  log_message(5, "Prefix ".($#pjq_prefix+1).", jqIP ".($#jq_ip+1).", done ".
#  (0+ keys %done_ip));
  @Idleworkers=('Irrelevantbogusvalue');
#  print '+';
  &give_jobs;
}

&finish;

exit;
#the main loop of a worker in a multiprocess setting
sub worker_main {
  my (@job,@result)=();

  &init_worker_connection();
  &log_message (4, "Worker starting activity");
  sleep 3;
  while(1) {
    &log_message (4, "Worker asking for job");
    @job = &remoteinvoke(DBCONNECTION,'special','getnextjob',@job,@result);
    &log_message (4, "Worker got job $job[0] $job[1]");
    last if ($job[0] eq 'exit');
    @result=&{$job[0]}(@job[1..$#job]);
  }
  &finish_worker();
  exit;
}

#the main loop of a central process in a multiprocess setting
#For now it knows only pure h4...
sub central_main {
  my ($k,$done,$rin,$win,$ein,$rout,$wout,$eout,);

  &init_server_connection;
  &give_jobs;
  $win=$ein='';
  $rin=&fhbits;
  while (@Workerfiledescriptors>0 and 
	 (@jq_hist> keys %done_hist or
	  @jq_domain> keys %done_domain or
	  @pjq_prefix>0 or
	  @jq_ip> keys %done_ip)) {
    select($rout=$rin,$wout=$win,$eout=$ein,undef);
#$s= "Active to read ";
#foreach $f ($listenfd,@Workerfiledescriptors) {
#	if (vec ($rout,$f,1))
#	  {$s.= "$f ";}
#  }
#$s.="\n";
#$s.=(join ' ' ,@Workerfiledescriptors);
#log_message(5,$s);
#    select($rout=$rin,$wout=$win,$eout=$ein,1);
#    if ($rout ne $zeromask) { #why else? OK, might add timeout later to select
    if (vec ($rout,$listenfd,1)) {#New worker connection
      &accept_new_worker;
      $rin=&fhbits;
      next;
    }
    my $f;
    foreach $f (@Workerfiledescriptors) {
      if (vec ($rout,$f,1)) { #this worker has something
	my $line;
	unless ($line=recvdata($fd2handle{$f})) {
	  @Workerfiledescriptors = (grep {$_ != $f}  @Workerfiledescriptors);
	  log_message (0,"Closing worker connection $fd2handle{$f}:$!");
	  close "$fd2handle{$f}";
	  $rin=&fhbits;
	  next;
	};
#print "*************$line\n";
	if ($line =~ /^([^ ]+) (.+)$/){
	  $funct=$1; 
	  $args=$2;
	} elsif ($line =~ /^([^ ]+)$/) {
	  $funct=$1;
	  $args='';
	} else {
	  @Workerfiledescriptors=(grep {$_ != $f} @Workerfiledescriptors);
	  log_message (0,"Bad syntax on worker connection $fd2handle{$f}".
		       "line: >$line<");
	  close "$fd2handle{$f}";
	  $rin=&fhbits;
	  next;
	}
	if ($funct ne 'special') {#the worker asked for some DB function
	  senddata ($fd2handle{$f},fastserialize(&$funct(fastparse($args))));
	} else { #here comes the complicated part
	  #for now we have a single special case (getnextjob), but
	  #this will change when we add SNMP
	  my @stuff=fastparse($args);
	  if ($stuff[1] eq 'hist_gen') {$done_hist{$stuff[2]}=1}
	  if ($stuff[1] eq 'h4_gen') {$done_domain{$stuff[2]}=1}
	  if ($stuff[1] eq 'h6_gen') {$done_domain{$stuff[2]}=1}
	  if ($stuff[1] eq 'h5_gen_C') {$done_ip{$stuff[2]}=1}
	  push @Idleworkers,$f;
	  &give_jobs();
	  log_message(4 ,"Workers :".($#Workerfiledescriptors+1).
		      " idle:".($#Idleworkers+1));
#	  print join(' ',@jq_domain);
#	  print "\n\n";
#	  print join(' ',keys %done_domain);
#	  print "\n\n";
	}
      }
    }
#    } #else {log_message (1,"Workers are lazy. I didn't hear of them
#      #recently")} 
  }
  while (@Idleworkers){#bye bye workers
    &senddata($fd2handle{(shift @Idleworkers)},'exit');
  }
  &finish;
  if (@jq_hist> keys %done_hist or
      @jq_domain> keys %done_domain or
      @pjq_prefix>0 or
      @jq_ip> keys %done_ip)
    {log_message(5,"Exited because no workers left");}
  
  exit;
}

#This function looks through the job queues and hands them out to idle
#workers 
sub give_jobs {
  while (@pjq_prefix) { #turn prefixes into addresses
    my ($prefix)=shift @pjq_prefix;
    my ($address,$mask)=@$prefix;
    my (@abyte,@mbyte,$i,$iprange,@netlist);
    @abyte=split (/\./,$address);
    @mbyte=split (/\./,$mask);
    for ($i=0;$i<3;$i++) {
      if ($mbyte[$i] eq 255) {
	$iprange .= "$abyte[$i].";
      } else {
	my $high=$abyte[$i]+255-$mbyte[$i];
	$iprange .= "[$abyte[$i]-$high].";
      }
    }
    $iprange .='1';
#  print "$iprange\n\n";
    @netlist=();
    &ipmaker_all(\@netlist,$iprange);
    add_unique (\@jq_ip,\%inq_ip,\@netlist);
  }
  while (@Idleworkers) {
    while ($crt_hist<@jq_hist and $done_hist{$jq_hist[$crt_hist]->[0]}) 
      {$crt_hist++;}
    if ($crt_hist<@jq_hist) {
      log_message(4, "Giving history job $crt_hist, $jq_hist[$crt_hist]->[0]");
      &$ctx_give_job($fd2handle{(shift @Idleworkers)},
		     "hist_gen ".join(' ',@{$jq_hist[$crt_hist]})); 
      $crt_hist++;
      next;
    }
    while ($crt_domain<@jq_domain and $done_domain{$jq_domain[$crt_domain]}) 
      {$crt_domain++;}
    if ($crt_domain<@jq_domain) {
      log_message(4, "Giving DNS job $crt_domain, $jq_domain[$crt_domain]");
      &$ctx_give_job($fd2handle{(shift @Idleworkers)},
		($no_dns_listing? "h6_gen $jq_domain[$crt_domain]": 
		 "h4_gen $jq_domain[$crt_domain]")); 
      $crt_domain++;
      next;
    }
    while ($crt_ip<@jq_ip and $done_ip{$jq_ip[$crt_ip]}) 
      {$crt_ip++;}
    if ($crt_ip<@jq_ip) {
      log_message(4, "Giving IP job $crt_ip, $jq_ip[$crt_ip]");
      &$ctx_give_job($fd2handle{(shift @Idleworkers)},
		"h5_gen_C $jq_ip[$crt_ip]"); 
      $crt_ip++;
      next;
    }
    last;
  }
}

#for making it possible to use give_jobs in both local and remote cases
sub give_remote_job {
  &senddata(@_);
}
sub give_local_job {
  my ($ignore,$job)=@_;
  my ($fct,@arg)=split (' ',$job);
  &$fct(@arg);
  if ($fct eq 'hist_gen') {$done_hist{$arg[0]}=1;}
  if ($fct eq 'h4_gen') {$done_domain{$arg[0]}=1;}
  if ($fct eq 'h6_gen') {$done_domain{$arg[0]}=1;}
  elsif ($fct eq 'h5_gen_C') {$done_ip{$arg[0]}=1;}
}

sub finish {
  $XXunvisited=0;
  $XXprobing=0;
  $XXalive=0;
  $XXdead=0;
  $XXtraced=0;
  $XXoutsidedomain=0;
  $XXbugs=0;
  foreach $a (keys %Visited)
    {if($Visited{$a} == 0)
       {$XXunvisited++}
     elsif($Visited{$a} == 1)
       {$XXprobing++}
     elsif($Visited{$a} == 2)
       {$XXalive.="  $a";}
     elsif($Visited{$a} == 3)
       {$XXdead++}
     elsif($Visited{$a} == 4)
       {$XXtraced++}
     elsif($Visited{$a} == 5)
       {$XXoutsidedomain++}
     else
       {print ">$Visited{$a}<"; $XXbugs++}
   }
  print "unvisited $XXunvisited, probing $XXprobing, alive(untraced) $XXalive, dead $XXdead, traced $XXtraced, outside domain $XXoutsidedomain, bugs $XXbugs\n";
  &ping_print_stats();
  &tracert_print_stats();
  &dns_print_stats();
  write_db($database);
  if ($historyfile) {write_history($historyfile)}
  if ($compressresults) {
    close THELOGFILE;
    system "/usr/local/gnu/bin/gzip $database/*";
  }
}

sub finish_worker {
  $XXunvisited=0;
  $XXprobing=0;
  $XXalive=0;
  $XXdead=0;
  $XXtraced=0;
  $XXoutsidedomain=0;
  $XXbugs=0;
  foreach $a (keys %Visited)
    {if($Visited{$a} == 0)
       {$XXunvisited++}
     elsif($Visited{$a} == 1)
       {$XXprobing++}
     elsif($Visited{$a} == 2)
       {$XXalive.="  $a";}
     elsif($Visited{$a} == 3)
       {$XXdead++}
     elsif($Visited{$a} == 4)
       {$XXtraced++}
     elsif($Visited{$a} == 5)
       {$XXoutsidedomain++}
     else
       {print ">$Visited{$a}<"; $XXbugs++}
   }
  print "unvisited $XXunvisited, probing $XXprobing, alive(untraced) $XXalive, dead $XXdead, traced $XXtraced, outside domain $XXoutsidedomain, bugs $XXbugs\n";
  &ping_print_stats();
  &tracert_print_stats();
  &dns_print_stats();
}

