
require 'common.pl';
require 'flush.pl';

sub tracert_init {
    
    $TRACES_SENT = 0;
    $TRACES_RECIEVED = 0;

# for UNIX systems, you never know where they put traceroute.
  if ( -x "/usr/local/etc/ftraceroute") {
      $TRACERT="/usr/local/etc/ftraceroute -n"; 
  } elsif (-x "/usr/local/sbin/ftraceroute") {
      $TRACERT="/usr/local/sbin/ftraceroute -n";
  } elsif (-x "/usr/sbin/ftraceroute") {
      $TRACERT="/usr/sbin/ftraceroute -n";
  } elsif ( -x "/usr/etc/ftraceroute") {
      $TRACERT="/usr/etc/ftraceroute -n"; 
  } else 
    {die "Could not find traceroute\n";}
 
  return 1;
}

sub tracert_print_stats {
    print "Traces sent = $TRACES_SENT, Traces received = $TRACES_RECIEVED\n";
    print "TRACERT_TIMEOUT = $TRACERT_TIMEOUT\n";
}

sub tracert {
    local($dest, $timeout) = @_;
    local($FOO);
    local(@addrs);
    local($blah) = 0;

    $TRACES_SENT++;

#    print ("$TRACERT -w $timeout $dest\n");
    open(FOO, "$TRACERT -w $timeout $dest|");
    while(<FOO>) {
#	print TRACES_FILE $_;
	if (/.*[\d+.*ms|\*].*[\d+.*ms|\*].*[\d+.*ms|\*].*\s([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+).*/) {
	    $TRACES_RECIEVED++;
	    push(@addrs, "$1.$2.$3.$4");
	} elsif (/.*\s([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+).*/) {
	    $TRACES_RECIEVED++;
	    push(@addrs, "$1.$2.$3.$4");
	} elsif (/.*\*.*/) {
	    $TRACES_RECIEVED++;
	    $blah = 1;
	    print STDERR "tracert: Path broken or ICMP failed\n";
	    close(FOO);
	    return @addrs;
	}
    }
    close(FOO);

    return @addrs;
}

sub tracert_ignore_errors {
    local($dest) = @_;
    local($FOO);
    local($addrs);
    local($blah) = 0;
    $TRACES_SENT++;

    open(FOO, "$TRACERT $dest|");
    while(<FOO>) {
	if (/.*[\d+.*ms|\*].*[\d+.*ms|\*].*[\d+.*ms|\*].*\s([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+).*/) {
	    push(@$addrs, "$1.$2.$3.$4");
	    $TRACES_RECIEVED++;
	} elsif (/.*\s([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+).*(\d+.*ms|\*).*(\d+.*ms|\*).*(\d+.*ms|\*).*/) {
	    push(@$addrs, "$1.$2.$3.$4");
	    $TRACES_RECIEVED++;
	} elsif (/.*\*\s*\*\s*\*.*/) {
	    $TRACES_RECIEVED++;
	    push(@$addrs, "0.0.0.0");
	    print STDERR "tracert: Path broken or ICMP failed\n";
	    close(FOO);
	    return $addrs;
	} elsif (/.*!H.*/) {
	    $TRACES_RECIEVED++;
	    push(@$addrs, "0.0.0.0");
	    print STDERR "tracert: Unix: Host unreachable\n";
	    close(FOO);
	    return $addrs;
	} elsif (/.*Destination host unreachable.*/) {
	    $TRACES_RECIEVED++;
	    push(@$addrs, "0.0.0.0");
	    print STDERR "tracert: Windows: Host unreachable\n";
	    close(FOO);
	    return $addrs;
	}
    }
    close(FOO);
    return $addrs;
}


return 1;

