
use SNMP;

#Input: a router name or IP in dotted format and a list of community strings
#Output: a SNMPdata structure

sub detailed_mib2_query
  {my ($router,@communities)=@_;
   my ($community,$result,$sysdescrV,$ipaddrV,$interfV,$routeV,$arpV);

   if ($#communities <0)
     {@communities=('public');}
   $sysdescrV=new SNMP::VarList(['sysDescr']);
   $interfV=new SNMP::VarList(['ifIndex'],['ifDescr'],['ifType'],['ifMtu'],
			     ['ifSpeed'],['ifOperStatus']);
   $ipaddrV=new SNMP::VarList(['ipAdEntAddr'],['ipAdEntIfIndex'],
			     ['ipAdEntNetMask'],['ipAdEntBcastAddr']);
   $routeV=new SNMP::VarList(['ipRouteDest'],['ipRouteIfIndex'],
			     ['ipRouteMask'],['ipRouteNextHop'],
			     ['ipRouteType']);
   $arpV=new SNMP::VarList(['atNetAddress']);

   foreach $community (@communities)
     {my $sess = new SNMP::Session(DestHost=>$router, Community=>$community);
      my ($descr,$ifid,$ifdes,$type,$mtu,$speed,$status,$ipaddr,$mask,$bcast,
	  $dest,$nexthop,$list);

      $descr=$sess->getnext($sysdescrV);
      if ($sess->{ErrorStr})
	{&log_message(4, "Error for $router($community): $sess->{ErrorStr}");
	 next;}
      $result=[$community,$descr];


      $list=[];
      for (($ifid,$ifdes,$type,$mtu,$speed,$status)=$sess->getnext($interfV);
	   $$interfV[0]->tag eq 'ifIndex' and not $sess->{ErrorStr};
	   ($ifid,$ifdes,$type,$mtu,$speed,$status)=$sess->getnext($interfV))
	{push @$list, [$ifid,$ifdes,$type,$mtu,$speed,$status];}
      push @$result,$list;

      $list=[];
      for (($ipaddr,$ifid,$mask,$bcast)=$sess->getnext($ipaddrV);
	   $$ipaddrV[0]->tag eq 'ipAdEntAddr' and not $sess->{ErrorStr};
	   ($ipaddr,$ifid,$mask,$bcast)=$sess->getnext($ipaddrV))
	{push @$list, [&dotted2long($ipaddr),&dotted2long($mask),
		       &dotted2long($bcast),$ifid];}
      push @$result,$list;

      $list=[];
      for (($dest,$ifid,$mask,$nexthop,$type)=$sess->getnext($routeV);
	   $$routeV[0]->tag eq 'ipRouteDest' and not $sess->{ErrorStr};
	   ($dest,$ifid,$mask,$nexthop,$type)=$sess->getnext($routeV))
	{push @$list, [&dotted2long($dest),&dotted2long($mask),
		       &dotted2long($nexthop),$ifid,$type];}
      push @$result,$list;

      $list=[];
      for ($ipaddr=$sess->getnext($arpV);
	   $$arpV[0]->tag eq 'atNetAddress' and not $sess->{ErrorStr};
	   $ipaddr=$sess->getnext($arpV))
	{push @$list, &dotted2long($ipaddr);}
      push @$result,$list;
      return $result;
    }
   return '';
  }


return 1;
