
# routines to store and retrieve the topology 

$DetailedSerialForm="1";

#Input: the type of the object and its serial representation
#Output: the object in internal representation
sub parse_object{
  my ($type,$serial)=@_;
  my (@chars,$escape,$typeref);
  local (@tokens);
        #this has to be 'local', not 'my' so that it's visible in
        #the functions called from here

  if (!defined($typeref=$Object{$type}))
    {die "Invalid object type -$type- passed to parser"}
  @chars=split //,$serial;
  for (($escape,@tokens)=('');$#chars>=0;shift @chars){
    if ($chars[0] =~ /[ {},:+n]/){
      if (!$escape)
	{push @tokens, $chars[0]}
      else{
	if ($chars[0] eq 'n')
	  {&add_to_last_token ("\n");}
	else
	  {&add_to_last_token ($char[0]);}
	$escape='';
      }
    }
    elsif ($chars[0] eq '\\'){
      if ($escape){
	&add_to_last_token ('\\');
	$escape='';
      }
      else
	{$escape='1'}
    }
    else{
      if ($escape)
	{die "Invalid serial representation, cannot escape -$char[0]- in -$serial-";}
      else
	{&add_to_last_token ($chars[0])}
    }
  }
  if ($escape)
    {die "Invalid serial representation, ends in \\ -$serial-";}
  return &process_tokens($typeref);
}

#Input: a character to add to last non-special token
#Output: works by side effect
#I add a - in front fo any non-special token so I can later distinguish
#between a special and a text token containing only a special
sub add_to_last_token{
  my ($char)=@_;

  if ($tokens[$#tokens] =~ /^[ {},:+]$/)
    {push @tokens,('-'.$char)}
  else
    {$tokens[$#tokens].=$char}
}

#Input: type descriptor
#Output: the internal description of the object in the tokens
sub process_tokens{
  my ($typeref)=@_;

  if (!ref($typeref))
    {return &build_scalar($typeref);}
  elsif (ref($typeref) ne 'ARRAY' || $#{$typeref}<0) 
    {die 'Bad type descriptor passed to parser'}
  elsif (ref($typeref->[0])){#we expect a "record"
    my ($result)=[];
    my ($i);
    &consume('{');
    for ($i=0;$i<=$#{$typeref};$i++)
      {last if ($tokens[0] eq '}');
       my ($field)=&process_tokens($typeref->[$i]);
       push @$result, $field;
       if ($tokens[0] ne '}') {&consume(',')};
     }
    &consume('}');
    return $result;
  }
  else{#we expect a field
    if ($#{$typeref}<2)
      {die "Type descriptor -@$typeref- too short in parser"}
    if($typeref->[1] eq 'o' && ($tokens[0] eq ','||$tokens[0] eq '}'))
      {return ''}
    if ($DetailedSerialForm){#field name
      &consume ("-$typeref->[0]");
      &consume (' ');
    }
    if ($typeref->[1] eq 'o' || $typeref->[1] eq '1')
      {if ($tokens[0] eq '}' || $tokens[0] eq ',')
	 #if I wanted to enforce 1 I should have checked here
	 {return '';}
       return &process_tokens($typeref->[2]);
     }
    elsif ($typeref->[1] eq 'm' || $typeref->[1] eq 'n')
      {my $result=[];
       &consume('{');
       while ($tokens[0] ne '}')
	 {push @$result, &process_tokens($typeref->[2]);
	  last if ($tokens[0] ne ',');
	  &consume (',');
	}
       &consume('}');
       return $result;
     }
    elsif ($typeref->[1] eq 'h')
      {if ($#{$typeref}<3)
	 {die "Type descriptor -@$typeref- too short for hash in parser"}
       my $result=[];
       &consume('{');
       if ($tokens[0] eq '}' || $tokens[0] eq ',')
	 #if I wanted to enforce 1 I should have checked here
	 {&consume('}');return '';}
       push @$result,&process_tokens($typeref->[2]);
      while ($tokens[0] ne '}')
	{&consume(',');
	 push @$result, &process_tokens($typeref->[3]);
	 &consume(':');
	 push @$result, &process_tokens($typeref->[2]);
       }
       &consume('}');
       return $result;
     }
    else
      {die "Unknown type descriptor selector in serializer -$typeref->[1]-"}
  }
}

#Input: a type name that can contain+
#Output: a string with the internal representation for the "scalar"
#The input starts with an non-special
#Parses a ...scalar
sub build_scalar{
  my ($type)=@_;
    
  if (defined($Scalar{$type}))
    {return &{$Scalar{$type}->[1]}(&consume_nonspecial);}
  if (defined($Enum{$type})){
    my $token=&consume_nonspecial;
    my $enum=$Enum{$type};
    if($DetailedSerialForm){
      my ($i);
      for($i=0;$i<=$#{$enum};$i++)
	{if($token eq $enum->[$i]){return $i}}
      die "Bad input -$token- for enum -$type-";
    }
    else{
      if ($token<0 || $token>$#{$enum})
	{die "Bad number -$token- for enum -$type-"}
      return $token;
    }
  }
  if (defined($Object{$type})){#I don't check for the validity of the counter
    my $token=&consume_nonspecial;
    my $name;
    if($DetailedSerialForm)
      {$name=$type}
    else
      {$name=''}
    if ($token !~ /^$name(\d+)$/ )
      {die "Bad id -$token- for object -$type-"}
    return $1;
  }
  if ($type=~/^[A-Za-z]+\+/){ #detect "collated" types
    my (@types)=split /\+/, $type;
    my (@result);
    for (@result=();$#types>=0;shift @types){
      if ($tokens[0]!~ /^-/ ) 
	{die "Invalid collated expression @result, extra +?";}
      push @result, &build_scalar($types[0]);
      if ($tokens[0] eq '+')
	{&consume('+');}
      else
	{return join "+",@result;}
    }
    die "Extra final + for collated expression @result";
  }
  die "Invalid type name -$type-";
}

#Input: Token or nothing
#Consumes a token by side effect
sub consume{
  my ($token)=@_;

#print $tokens[0];
  if ($#tokens<0)
    {die "Input to parser too short"}
  if ($token &&($token ne $tokens[0]))
    {
print xxx
die "Input mismatch, -$tokens[0]- found where -$token- expected"}
  shift @tokens;
}

#Input: nothing
#Consumes a non-special token and strips the - and returns it
sub consume_nonspecial{
  my ($token);

#print $tokens[0];
  unless ($token=(shift @tokens))
    {die "Input to parser too short"}
  if ($token !~ /^-(.+)$/)
    {die "Input mismatch, -$tokens[0]- found where non-special expected"}
  return $1;
}

#input: any string
#Output: the same string with the special characters escaped
sub escape_specials{
  my ($string)=@_;
  my (@chars,$result);

  @chars=split //,$string;
  for ($result="";$#chars>=0;shift @chars){
    if ($chars[0]=~/[ {},:+\\]/)
      {$result.='\\'.$chars[0];}
    elsif ($chars[0] eq "\n")
      {$result.="\\"."n"}
    else
      {$result.=$chars[0];}
  }
  return $result;
}

#Input: typename and internal representation of a scalar, enum or object
#Output: serial representation
#This doesn't weed out unwanteed characters or check ids yet............
sub serialize{
  my ($type,$value)=@_;
#die;
  if (ref($type))#If it's already a type representation, not a type name
    {return &serialize_object($type,$value)}
  if (defined($Scalar{$type}))
    {return &escape_specials(&{$Scalar{$type}->[0]}($value));}
  if (defined($Enum{$type})){
    my $enum=$Enum{$type};
    if ($value<0 || $value>$#{$enum})
       {die "Bad value -$value- for enum -$type-"}
    return &escape_specials($DetailedSerialForm?"$enum->[$value]":"$value");
  }
  if (defined($Object{$type})){
    if (ref($value))#we have the object itself
      {return &serialize_object($Object{$type},$value)}
    else #we have only the object id
      {return &escape_specials($DetailedSerialForm?"$type$value":"$value")}
  }
  if ($type=~/^[A-Za-z]+\+/) #detect "collated" types
    {my (@types)=split /\+/, $type;
     my (@vals)=split /\+/, $value;
     my ($i,@result);
     if ($#vals > $#types)
       {die "Too many values -$value- for collated type -$type-"}
     for (($i,@result)=("0");$i<=$#vals;$i++)
       {push @result, &serialize ($types[$i],$vals[$i])}
     return join "+",@result;
   }
  die "Invalid type name -$type-";
}

#Input:
#Output:
#serializes an object or a field....
sub serialize_object{
  my ($typeref,$data)=@_;
  my (@serialdata);

  if ((ref($typeref) ne 'ARRAY') || $#{$typeref}<0) 
    {die 'Bad type descriptor passed to serializer'}
  if (ref($typeref->[0])) #we have a "record"
    {my ($i,@serialdata);
     if(ref($data) ne 'ARRAY')
       {die 'Bad data passed to serializer'}
     if($#{$data} > $#{$typeref})
       {die "Data -@$data- passed to serializer too long for type -@$typeref-"}
     for (($i,@serialdata)=(0); $i<= $#{$typeref};$i++)
       {last if ($i > $#{$data});
	push @serialdata, &serialize_object($typeref->[$i],$data->[$i]);
      };
     return '{'.join(',',@serialdata).'}'
   }#we have a "field"
  else
    {my ($prefix);#only for storing the type name and a space (if needed)
     if ($#{$typeref}<2)
       {die "Type descriptor -@$typeref- too short in serializer"}
     if ($DetailedSerialForm)
       {$prefix=$typeref->[0].' '}
     else
       {$prefix=''}
     if ($typeref->[1] eq '1')#should check for existence of data.....
       {return $prefix. &serialize($typeref->[2],$data)}
     elsif ($typeref->[1] eq 'o'){
       if ($data ne '')
	 {return $prefix. &serialize($typeref->[2],$data)}
       else
	 {return ''}
     }
     elsif ($typeref->[1] eq 'n' || $typeref->[1] eq 'm')
       {if (ref($data) ne 'ARRAY')
	  {if (!$data)
	     {$data=[];}
	   else
	     {die "$typeref->[0]+$typeref->[1]+$typeref->[2] - bad list data passed to serializer >$data<"}
	 }
	return $prefix.'{'.join(',',map({&serialize($typeref->[2],$_)} @$data)).'}'
      }
     elsif ($typeref->[1] eq 'h')
       {if ($#{$typeref}<3)
	  {die "Type descriptor -@$typeref- too short for hash in serializer"}
	if (ref($data) eq 'ARRAY' && $#$data>=0)
	  {my @result=();
	   my $default=&serialize($typeref->[2],$data->[0]);
	   my $i;
	   for ($i='1';$i<$#{$data};$i+=2)
	     {push @result, (&serialize($typeref->[3],$data->[$i]) .':'.
			     &serialize($typeref->[2],$data->[$i+1]))}
	   if ($i == $#{$data})
	     {die "List -@$data- with an even number of elements as hash"}
	   return $prefix.join(',',("{$default",@result)).'}';
	 }
	die 'Bad hash data passed to serializer'; #invalid representation
       }
     else
       {die "Unknown type descriptor selector in serializer -$typeref->[1]-"}
   }
}

