
require 'inet.pl';
require 'flush.pl';

# returns 1 if ping works else returns 0
sub ping_init {

  $PINGS_SENT = 0;
  $PINGS_RECEIVED = 0;
  # arbitrary => usually timeout less than 10000 ms.
  $PING_MAX = 0;
  $PING_AVG = 0;
  $PING_MIN = 10000;
  $PING_TIMEOUT_TEST = 100;
  $PING_LARGER = 0;


  if ( -x "/usr/sbin/bping" ) 
    {$BPING="/usr/sbin/bping";}
  elsif ( -x "/usr/local/sbin/bping" ) 
    {$BPING="/usr/local/sbin/bping";}
  else
    {die "Could not find bping"}
  return 1;
}

sub ping_print_stats {
    local ($percentile);
    print "Pings sent = $PINGS_SENT, Pings received = $PINGS_RECEIVED\n";
    print "maximum ping rtt = $PING_MAX ms, minimum rtt = $PING_MIN ms\n";
    print "average ping rtt = $PING_AVG ms\n";
    if ($PINGS_RECEIVED)
    {$percentile = (($PINGS_RECEIVED - $PING_LARGER) / $PINGS_RECEIVED) * 100;}
    print "timeout $PING_TIMEOUT_TEST ms is the $percentile% percentile\n";
    print "PING_TIMEOUT=$PING_TIMEOUT BATCHSIZE=$BATCHSIZE\n";
}

sub bping_cmdline {
  local($file, $size, $cnt, $timeout)=@_;

# this will automatically return an error, thus will be
# OK. This is to fix the "freezing" problem on solaris
# when a null address is given and it just stops
  if ($file eq '') { return "Invalid Ping"; }

  return "$BPING $file $size $cnt $timeout|";

}

sub bping_alive {
  local($timeout,@addrs)=@_;
  local(*HOSTFILE, *FOO);
  local(@retlist) =();
  local($cnt) = 0;

  $PINGS_SENT+=@addrs;

  # construct the hosts list
#  open(HOSTFILE, ">hosts.txt");
#  foreach $hostname (@addrs) {
#      print HOSTFILE "$hostname\n";
#  }
#  close HOSTFILE;


  # open(FOO,"$PING -s $addr 64 2|");
  open(FOO,&bping_cmdline(join(',',@addrs), 8, 1, $timeout));
  # find the start of the PRT
#print ">>>>>>>>>>>>>>>>>>>>>\n";
#  while (<FOO>) {
#    print $_;
#      if (/.*min\/avg\/max = ([0-9]+)\/([0-9]+)\/([0-9]+).*/) { 
#	  $min = $1;
#	  $avg = $2;
#	  $max = $3;
#	  last;
#      }
#  }

#print "<<<<<<<<<<<<<<<<<<<<\n";

  if ($max > $PING_TIMEOUT_TEST) {
      $PING_LARGER++;
  }
#  $PING_MIN = $min if ($min < $PING_MIN);
#  $PING_AVG = ($avg * @addrs + $PING_AVG * $PINGS_RECEIVED) / 
#      ($PINGS_RECEIVED + @addrs);
#  $PING_MAX = $max if ($max > $PING_MAX);

  while (<FOO>) {
      if (/PRT\s-\s.*/) { 
	  last;
      }
  }
  while (<FOO>) {
    if (/.*alive.*/) {
	$PINGS_RECEIVED++;
	push @retlist, $addrs[$cnt];
    }
    $cnt++;
  }
  close FOO;
  return @retlist;
}

return 1;
