
#Input: the ids of a firsthop and a secondhop and the seen IP of secondhop
#Adds to the database the information that these are one hop away, adjusting
#subnets if necessary
sub add_link
  {my ($first,$second,$addr)=@_;
   my $gw=$Computer[$first];
   my $end=$Computer[$second];
   
   #checking/setting lasthop information
   {my ($lasthop);
    $lasthop=$end->[4];

      {unless (&$ctx_treat_bad_lasthop($end,$gw)) {return}}
    $end->[4]=$first;
    if ($gw->[2])
      {&convert_host_to_router($gw);}
  }
   #checking gateway subnet information
   {my ($subnet,$ip,$crt_s,$crt_ip)=('','');
    
    foreach $crt_ip (@{$end->[0]})
      {foreach $crt_s (@{$gw->[3]->[0]})
	 {if (($Subnet[$subnet]->[1] & $crt_ip)eq $Subnet[$crt_s]->[0])
	    {$ip=$crt_ip;
	     $subne=$crt_s;
	     if($ip eq $addr)
	       {goto DONE}
	   }
	}
     }
  DONE:
    {if ($ip ne '')
       {if($ip ne $addr)
	  {&$ctx_saw_other_address($ip,$addr,$end,$gw);}
	&add_computer_to_subnet($end,$subnet,$ip);
	return;
      }
   }
  }
   #checking gateway link information
   if (grep {$second == $_} @{$gw->[3]->[1]})
     {return}
   #try to store this as a subnet
   {my ($crt_gw,$crt_end,$min_gw,$min_end,$net,$mask,$subnet,@overlap);
    $mask = $NULL_MASK;
    foreach $crt_gw (@{$gw->[0]}) 
      {foreach $crt_end (@{$end->[0]}) 
	 {my $temp_xor= ~($crt_gw ^ $crt_end);
	  if (&more_specific($temp_xor,$mask))
	    {$mask = $temp_xor;
	     $min_gw = $crt_gw;
	     $min_end = $crt_end;
	   }
	}
     }
    $mask = &fix_mask($mask);
    #Check mask for a maximum
    if (!&more_specific($MAX_MASK,$mask))
      {$net = $min_end & $mask;
       @overlap = &overlapping_subnets($net,$mask);

       if ($#overlap == -1)
	 {my $subnetid=&create_subnet($net,$mask);
	  &add_computer_to_subnet($end,$subnetid,$min_end);
	  &add_computer_to_subnet($gw,$subnetid,$min_gw);
	  return;
	}
       elsif ($#overlap == 0) #overlapping with exactly one subnet
	 {if(&more_specific($Subnet[$overlap[0]]->[1],$mask))
	    #can extend an existing subnet
	    {if (&extend_netmask($Subnet[$overlap[0]],$mask))
	       {&add_computer_to_subnet($end,$overlap[0],$min_end);
		&add_computer_to_subnet($gw,$overlap[0],$min_gw);
		return;}
	   }
	  elsif ($Subnet[$overlap[0]]->[1] eq $mask)
	    {#&$ctx_report_weird_case($end,$gw,$min_end,$min_gw,$Subnet[$overlap[0]]);
	      &add_computer_to_subnet($end,$overlap[0],$min_end);
	      &add_computer_to_subnet($gw,$overlap[0],$min_gw);
	      return;
	    }
	  else
	    {#&$ctx_report_bad_case($end,$gw,$min_end,$min_gw,$Subnet[$overlap[0]]);
	      &add_computer_to_subnet($end,$overlap[0],$min_end);
	      &add_computer_to_subnet($gw,$overlap[0],$min_gw);
	      return;
	    }
	}
     }
    
    &add_link_to_router($gw,$second);
  }
 }

return 1;
