use Socket;

sub long2dotted 
  {my($l) = @_;
   my(@bytes)=unpack ("C4",$l);

   return join ('.',@bytes);
 }

sub dotted2long 
  {my($addr)=@_;

   if ($addr =~ /([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+).*/ ) {
     return  pack ("C4",($1,$2,$3,$4));
   }
   return '';
 }

#Network to host format
sub ntoh
  {my ($addr)=@_;
   my $dotted=inet_ntoa($addr);

   return dotted2long($dotted);
 }

#Host to network format
sub hton
  {my ($addr)=@_;
   my $dotted=long2dotted($addr);

   return inet_aton($dotted);
 }

#I think these two can be improved.............

#Input: a tentative netmask in long format
#Output: all digits after the first zero get zeroed
sub fix_mask 
  {my ($temp_netmask) = @_;
   my ($i,$string);
   
   $string=unpack("B32",$temp_netmask);
   for ($i=0; $i<32 ;$i++)
     {last if (substr ($string,$i,1) eq '0')}
   for (; $i<32; $i++)
     {substr ($string,$i,1)='0';}
    return pack ("B32",$string);
 }

#Input: two netmasks (possibly with some 1s after the first 0)
#Output: true if the first is more specific
sub more_specific 
#I don't do this with gt to avoid locale problems
  {my ($mask1,$mask2)=@_;
   my ($i,$string1,$string2);
   
   $string1=unpack("B32",$mask1);
   $string2=unpack("B32",$mask2);
   for ($i=0; $i<32 ;$i++)
     {if (substr ($string1,$i,1) eq '0')
	{return 0}
      if (substr ($string2,$i,1) eq '0')
	{return 1;}
    }
   return 0;
 }

return 1;
