
use Socket;

# returns 1 if dns is available
sub dns_init{
    %NS_CACHE = {};
    %NS_INV_CACHE = {};
    $NS_LOOKUP = 0;
    $NS_INV_LOOKUP = 0;
    $NS_CACHE_MISS = 0;
    $NS_INV_CACHE_MISS = 0;
    $NSLOOKUP = './nslookup';
    return 1;
}

#Input: a string with a computer name
#Output: the list of its addresses in the long format
#(Checks cache first)
sub dns_name2addrs{
  my($name)=@_;
  my($aliases, $addrtype, $length, @addrs, $cachepointer);

  $NS_LOOKUP++;
  if (defined ($cachepointer = $NS_CACHE{$name})){
    return @$cachepointer;}
  $NS_CACHE_MISS++;
  ($name, $aliases, $addrtype, $length, @addrs) = gethostbyname($name);
  $NS_CACHE{$name} = \@addrs;
  return map {&ntoh($_)} @addrs;
}

#Input: an address in the long format
#Output: the name that's returned by DNS from inverse lookup
#(Checks cache first)
sub dns_addr2name{
   my($addr)=@_;
   my($name);

   $NS_INV_LOOKUP++;
   $name = $NS_INV_CACHE{$addr};
   return $name if ($name);
   $NS_INV_CACHE_MISS++;
   $name = gethostbyaddr(&hton($addr), AF_INET);
   $name =~ tr [A-Z] [a-z];
   $NS_INV_CACHE{$addr} = $name;
   return $name;
}

#Input: a domain (with no dotat the end) and possibly an authoritative NS
#Output: a list with the list of addresses and the one of subdomains
sub dns_ls 
  {my ($domain,$server)=@_;
   my ($line,$serverlist);

   $domain =~ tr/A-Z/a-z/;

   open(DNSFOO,">foo.$domain");
   print DNSFOO "set timeout=5\nset retry=2\nls -d $domain\n";
   close(DNSFOO);

   if ($server) 
     {open(DNSDATA,"$NSLOOKUP - $server < foo.$domain|");}
   else
     {open(DNSDATA,"$NSLOOKUP < foo.$domain|");}
   $serverlist='';
   #reading the garbage
   my($addrs,$subdomains,$name) = ([],[],'');
   while($line=<DNSDATA>)
     {if ($line =~ /\*\*\*/)
	{if($serverlist eq '')
	   {$serverlist=&get_servers($domain)}
	 if($#$serverlist <0)
	   {last;}
	 $server=shift @$serverlist;
	 close DNSDATA;
print "+++$server+++\n";
	 open(DNSDATA,"$NSLOOKUP - $server < foo.$domain|");
	 $name='';
       }

      $line =~ s/^\s?(.*)/$1/;
      if ($line =~ s/^(\S+)(.*)/$2/)
	{my($n)=$1;
	 if ($n !~ /^[a-zA-Z0-9\-\.]+$/)
	   {$name='';}
	 else
	   {$n =~ tr/A-Z/a-z/;
	    if ($n =~ /(.*)\.$/) {$n=$1}
	    elsif ($n !~ /$domain$/) {$n.='.'.$domain;}
	    $name=$n;
	  }
       }
      if (!$name)
	{next;}
      my(@word)=split /\s+/, $line;
      if (!$word[0])
	{shift @word;}
      if($word[0] !~ /^(A|NS)$/)#/^(A|NS|HINFO|MX|CNAME)$/
	{shift @word;
	 if($word[0] !~ /^(A|NS)$/)
	   {shift @word;
	    if($word[0] !~ /^(A|NS)$/) {next;}
	  }
       }
      if ($word[0] eq 'A')
	{my ($addr)=&dotted2long($word[1]);
	 push @$addrs, $addr;
	 &add_to_cache($name,$addr);
       }
      else
	{if($name ne $$subdomains[$#$subdomains])
	   {push @$subdomains, $name;}
       }
    }
   close(DNSDATA);
   system("rm foo.$domain");
   my (@result)=($addrs,$subdomains);
   return @result;
 }

sub get_servers
  {my ($domain)=@_;
   my ($line,%servers,@addrs,@result);

   open(DNSBAR,">bar.$domain");
   print DNSBAR "set timeout=5\nset retry=2\nset type=NS\n$domain\n";
   close(DNSBAR);
   open(DNSDATA,"$NSLOOKUP <bar.$domain|");
   %servers=();
   @addrs=();
   while($line=<DNSDATA>)#get all nameservers
     {if($line =~ /$domain\s+nameserver\s+=\s+([a-zA-Z0-9\-\.]+)/)
	{my $name=$1;
	 $name =~ tr/A-Z/a-z/;
	 $servers{$name}='1';
       }
      if($line =~ /([a-zA-Z0-9\-\.]+)\s+internet\s+address\s+=\s+([0-9\.]+)/)
	{my ($name,$address)=($1,$2);
	 $name =~ tr/A-Z/a-z/;
	 if ($servers{$name} && ($address=&dotted2long($address)))
	     {push @addrs,&long2dotted($address);}
       }
    }
   close DNSDATA;
   system("rm bar.$domain");
   if ($#addrs>=0)
     {@result = &bping_alive($PING_TIMEOUT*10,@addrs);}
   return \@result;
 }

sub rec_dns
  {my ($domain)=@_;

print "--$domain--\n";

   my ($addrs,$doms)=&dns_ls($domain);
   
   if ($doms && $#$doms>-1)
     {my ($subdom);
      foreach $subdom (@$doms)
	{my $sdaddrs;
	 next if ($subdom !~ /\.$domain$/);
	 if($sdaddrs=&rec_dns($subdom))
	   {push @$addrs, @$sdaddrs;}
       }
    }
   return $addrs;
 }

sub add_to_cache
  {my ($name,$addr)=@_;
   my $ptr=$NS_CACHE{$name};
   
   if (!defined ($ptr))
    {$NS_CACHE{$name} = [$addr];}
   else
     {if (grep {$addr eq $_} @$ptr)
	{return}
      push @$ptr,$addr;}
 }


sub dns_print_stats {
    local($hit, $invhit);
    $hit = $NS_LOOKUP - $NS_CACHE_MISS;
    $invhit = $NS_INV_LOOKUP - $NS_INV_CACHE_MISS;
    print "ns forward lookup : cache hit : $hit/$NS_LOOKUP\n";
    print "ns inverse lookup : cache hit : $invhit/$NS_INV_LOOKUP\n";
}

return 1;

