#routines for interfacing with the topology database

@Computer=('');
@Subnet=('');
@SNMPdata=('');
%IP2Comp=();

#Input: the IP address of a computer (host or router) to be added
#Output: the id of the computer (cannot be 0) or '' if it's rejected
sub store_computer
  {my($addr)=@_;
   my ($id,$name,@addrs,$node);
   
   if (defined ($id=$IP2Comp{$addr}))
     {return $id}
   $name=&dns_addr2name($addr);
   if ($name)
     {@addrs=&dns_name2addrs($name);
      if (! grep {$addr eq $_} @addrs)
	{unshift @addrs,$addr;}
    }
   else
     {@addrs=($addr);}
   $node=[\@addrs,[$name]];
   if ($#addrs > 0)# it is a router
     {push @$node,'';
      push @$node,[];}
   else # it is a host
     {push @$node,[];}
   if (!&is_interesting($node->[0],$node->[1]))
     {if (! &$ctx_process_uninteresting($node))
	{return ''}
    }
   push @Computer,$node;
   $id = $#Computer;
   foreach $addr (@addrs)
     {$IP2Comp{$addr}=$id;}
   return $id;
 }

#Input: a computer iplist and a name structure
#Output: whether it is in the domain that's currently discovered (target)
#Checks only first name
sub is_interesting
  {my ($iplist,$names)=@_;
   my ($ip,$name);

   $name=$names->[0];
   if (!$name)
     {if (!$ctx_accept_nodns)
	{return '';}}
   else
     {my $i;
      for ($i=0;$i<=$#ctx_dns_target;$i++)
	{last if ($name =~ /\.$ctx_dns_target[$i]$/)}
      if ($i>$#ctx_dns_target)
	{return '';}
    }
   foreach $ip (@{$iplist})
     {my $subnet;
      foreach $subnet (@ctx_ip_target)
	{return '1' if (("$ip" & "$subnet->[1]") eq $subnet->[0])}
     }
   return '';
 }

#Input: a computer structire
sub convert_host_to_router
  {my ($computer)=@_;
   my $routerdata=[]; 

   if ($computer->[3])
     {return}
   if ($computer->[2]->[0])#add the subnet
     {push @$routerdata,$computer->[2]->[0]}
   $computer->[3]->[0]=$routerdata;
   $computer->[2]='';
   return;
  }

sub add_link_to_router
  {my ($gw,$computer)=@_;

   if ($gw->[3]->[1])
     {push @{$gw->[3]->[1]},$computer}
   else
     {$gw->[3]->[1]=[$computer]}
  }

#Input: a computer structure, a subnet id and the address of the computer
#that's on the subnet
#Effect: adds the ip to the subnet and updates the computer structure so
#it knows that it's part of this subnet
sub add_computer_to_subnet
  {my ($comp,$subnet,$addr)=@_;

   if ($comp->[2])
     {if (!$comp->[2]->[0])
	{$comp->[2]->[0]=$subnet;}
      else
	{if ($comp->[2]->[0] == $subnet)
	   {return}
	 &convert_host_to_router($comp);
       }
    }
   if ($comp->[3])
     {my $crt;
      foreach $crt (@{$comp->[3]->[0]})
	{return if ($subnet == $crt)}
      push @{$comp->[3]->[0]}, $subnet;
    }
   if ($Subnet[$subnet]->[3])
     {push @{$Subnet[$subnet]->[3]},$addr;}
   else
     {$Subnet[$subnet]->[3]=[$addr];}
 }


#Input: a subnet IP + netmask
#Output: the list of the ids of the overlapping subnets
sub overlapping_subnets
  {my ($net,$mask)=@_;
   my ($i,@result);
   
   for (($i,@result)=(0); $i<=$#Subnet; $i++)
     {next unless ($Subnet[$i]);
      if (&more_specific($mask,$Subnet[$i]->[1]))
	{push (@result,$i) if (($net & $Subnet[$i]->[1])eq $Subnet[$i]->[0])}
      elsif (&more_specific($Subnet[$i]->[1],$mask))
	{push (@result,$i) if ($net eq ($Subnet[$i]->[0] & $mask))}
      else
	{push (@result,$i) if ($net eq $Subnet[$i]->[0])}
    }
   return (@result);
 }

#Input: the ids of the source and destination subnet
#Moves all computers to the new subnets, updating their subnet field too
sub move_all_computers
  {my ($src,$dest)=@_;
   my ($ip);

   foreach $ip (@{$Subnet[$src]->[3]})
     {my ($comp,$i);
      $comp=$Computer[$IP2Comp{$ip}];
      if($comp->[2])
	{$comp->[2]->[0]=$dest;}
      elsif($comp->[3])
	{for ($i=0;$i<=$#{$comp->[3]->[0]};$i++)
	   {if($comp->[3]->[0]->[$i] eq $src)
	      {$comp->[3]->[0]->[$i]=$dest;
	       last;}
	  }
       }
      else
	{&log_message(1,"Bad computer structure:".&serialize('Computer',$comp));}
    }
   push @{$Subnet[$dest]->[3]},@{$Subnet[$src]->[3]}
  }

sub create_if_possible
  {my ($net,$mask)=@_;
   my (@overlap);

   @overlap=&overlapping_subnets($net,$mask);
   if ($#overlap<0)
     {return &create_subnet($net,$mask);}
   elsif ($#overlap == 0)
     {if ($mask eq $Subnet[$overlap[0]]->[1])
	{return $overlap[0];}
      elsif (&more_specific($Subnet[$overlap[0]]->[1],$mask))
	{if (&extend_netmask($Subnet[$overlap[0]],$mask))
	   {return $overlap[0];}
	 else
	   {return '';}
       }
      else
	{&log_message(3,"Cannot shrink subnet".
		      &serialize('Subnet',$Subnet[$overlap[0]]).
		      " to ".&long2dotted($mask));
	 return '';}
    }
   else
     {return &combine_subnets($net,$mask,\@overlap);}
 }

sub combine_subnets
  {my ($net,$mask,$list)=@_;
   my ($id);

   if($#$list<1)
     {&log_message(1,"Attempt to combine too few ($#$list+1) subnets into ".
		   &long2dotted($net)."/".&long2dotted($mask));
      return &create_subnet($net,$mask);
    }
   foreach $id (@$list)
     {&extend_netmask($Subnet[$id],$mask);}
   $target=shift @$list;
   foreach $id (@$list)
     {&move_all_computers($id,$target);}
   foreach $id (@list)
     {$Subnet[$id]=''}
   return $target;
 }
sub create_subnet
#Should check for empty slots left by deleted subnets....
  {my ($net,$mask)=@_;

   push @Subnet,[$net,$mask,$ctx_subnet_method];
   return $#Subnet;
 }

sub extend_netmask
  {my ($subnet,$mask)=@_;

   if ($ctx_subnet_method<$subnet[2])
     {return '';}
   if ($ctx_subnet_method==$subnet[2] and $ctx_subnet_method==1)
     {&log_message(2,"SNMP subnet inconsistency:".&long2dotted($subnet->[0]).
		   " extended from ".&long2dotted($subnet->[0])." to ".
		   &long2dotted($mask));}
   $subnet->[0]=($mask & $subnet->[0]);
   $subnet->[1]=$mask;
   return 1;
 }


#Input: a router IP (in long format) and SNMPdata
#Output: the id of the router
sub add_snmp_data
  {my($router,$data)=@_;
   my($id,@oldip,@newip,@oldsubn,@newsubn,$n,$i,$newlist);
   local($ctx_subnet_method)=1;

   unless ($id=&store_computer($router)) {return ''}
   @oldip=sort @{$Computer[$id]->[0]};
   @newip=sort (map {$_->[0]} @{$data->[3]});
   @newip=grep {$_ ne $LOCALHOST} @newip;
   unless (grep {$router eq $_} @newip)
     {&log_message(1, "Router address ".&long2dotted($router).
		   " is not in ".&serialize('SNMPdata',$data));
      return ''}
   $newlist=[];
   #check IP addresses

   for (($i,$n)=(0,0);$i<=$#oldip and $n<=$#newip;)
     {if($oldip[$i] eq $newip[$n])
	{$i++;$n++;
	 push @$newlist,$newip[$i];}
      elsif($oldip[$i] lt $newip[$n])
	{&log_message(3,"Extra IP address ".&long2dotted($oldip[$i]).
		      " found in router $Computer[$id]->[1]->[0]");
	 undef $IP2Comp{$oldip[$i]};
	 $i++;
       }
      else
	{&log_message(3,"IP address ".&long2dotted($newip[$n]).
		      " not found in router $Computer[$id]->[1]->[0]");
	 $IP2Comp{$newip[$n]}=$id;
	 push @$newlist,$newip[$i];
	 $n++;
       }
    }
   while ($i<=$#oldip)
     {&log_message(3,"Extra IP address ".&long2dotted($oldip[$i]).
		      " found in router $Computer[$id]->[1]->[0]");
      undef $IP2Comp{$oldip[$i]};
      $i++;
    }
   while($n<=$#newip)
     {&log_message(3,"IP address ".&long2dotted($newip[$n]).
		      " not found in router $Computer[$id]->[1]->[0]");
      $IP2Comp{$newip[$n]}=$id;
      push @$newlist,$newip[$i];
      $n++;
    }
   $Computer[$id]->[0]=$newlist;

   #check subnets
   @newip=map ({[($_->[0] & $_->[1]),$_->[1]]} @{$data->[3]});
   @newsubn=();
   foreach $i (@newip)
     {if($n=&create_if_possible($i->[0],$i->[1]))
	{push @newsubn,$n}
    }
   if ($#newsubn <0)
     {&log_message(2, "No suitable subnets in SNMPdata ".
		   &serialize('SNMPdata',$data));
      return ''}
   elsif ($#newsubn == 0)
     {my ($comp);
      $comp=$Computer[$id];
      if($comp->[2])
	{$comp->[2]->[0]=$newsubn[0];}
      elsif($comp->[3])
	{$comp->[3]->[0]=[$newsubn[0]];}
      else
	{&log_message(1,"Bad computer structure:".
		      &serialize('Computer',$comp));}
    }
   else
     {my ($comp);
      $comp=$Computer[$id];
      if($comp->[2])
	{&convert_host_to_router($comp);}
      @oldsubn=sort (@{$comp->[3]->[0]});
      @newsubn=sort @newsubn;
      $newlist=[];
      for (($i,$n)=(0,0);$i<=$#oldsubn and $n<=$#newsubn;)
	{if($oldsubn[$i] eq $newsubn[$n])
	   {$i++;$n++;
	    push (@$newlist,$newsubn[$n]);
	  }
	 elsif($oldsubn[$i] lt $newsubn[$n])
	   {&log_message(3,"Extra subnet $oldsubn[$i]) found in router $comp->[1]->[0]");
	    $i++;
	  }
	 else
	   {&log_message(4,"Subnet $newsubn[$n]) not found in router $comp->[1]->[0]");
	    push (@$newlist,$newsubn[$n]);
	    $n++;
	  }
       }
      while($i<=$#oldsubn)
	{&log_message(3,"Extra subnet $oldsubn[$i] found in router $comp->[1]->[0]");
	 $i++;
       }
      while($n<=$#newsubn)
	{&log_message(4,"Subnet $newsubn[$n] not found in router $Computer[$id]->[1]->[0]");
	 push (@$newlist,$newsubn[$n]);
	 $n++;
       }
      $comp->[3]->[0]=$newlist;
    }
   if ($Computer[$id]->[3])
     {push @SNMPdata,$data;
      $Computer[$id]->[3]->[2]=$#SNMPdata;
    }
   else
     {&log_message(4,"It's unusual to get SNMP data from a non-router".
		  &serialize('Computer',$Computer[$id]))}
   return $id;
 }

sub store_init {
  local($dir)=@_;

  system("mkdir $dir") if  ! -d $dir ;
}


return 1;
