# Global Data Structures

#-------------------------------------------------------
#Internal repressentation of type information (maybe one day it will
#be get parsed from a file....)
#-------------------------------------------------------

%Scalar=
  ('IP'=>[\&long2dotted,\&dotted2long],
   'Name'=>[\&no_processing,\&no_processing],
   'Time'=>[\&no_processing,\&no_processing],
   'Delay'=>[\&no_processing,\&no_processing],
   'SNMPcom'=>[\&no_processing,\&no_processing],
   'Mask'=>[\&long2dotted,\&dotted2long],
   'OSPFcost'=>[\&no_processing,\&no_processing],
   'Filename'=>[\&no_processing,\&no_processing],
   'Text'=>[\&no_processing,\&no_processing],
#   'ifType'=>[\&no_processing,\&no_processing],
  );

%Enum=
  ('Service'=>['mail','web','ftp'],
   'Subnetmethod'=>['guessing','SNMP'],#higher number means we trust it more
   'Addressmethod'=>['DNS','SNMP'],
  );

%Object=
  ('Eye'=>[['ip','1','IP'],
	   ['timeshift','1','Delay'],
	  ],
   'Computer'=>[['ip','m','IP'],
		['name','h','Name','IP'],
		['host','o',[['subnet','o','Subnet'],
			     ['service','n','Service'],
			    ],
		],
		['router','o',[['subnet','n','Subnet'],
			       ['link','n','Computer'],
#			       ['link','n','Computer+Link'],
			       ['snmpdata','o','SNMPdata'],
			       ['ospf','o',[['routerid','1','IP'],
					    ['area','m','IP'], 
					   ],
			       ],
			      ]
		],
		['lasthop','o','Computer'],
#		['lasthop','h','Computer','Eye'],
		['delay','h','Delay+Time','Eye'],
		['down','h','Time','Eye'],
	       ],
   'Subnet'=>[['ip','1','IP'],
	      ['mask','1','Mask'],
	      ['method','1','Subnetmethod'],
	      ['host','n','IP'],
	      ['lasthop','h','Computer','Eye'],
	     ],
   'SNMPdata'=>[['community','1','SNMPcom'],
		['sysDescr','o','Text'],
		['interfaces','n',[['ifIndex','o','Text'],
				   ['ifDescr','o','Text'],
				   ['ifType','o','Text'],
				   ['ifMtu','o','Text'],
				   ['ifSpeed','o','Text'],
				   ['ifOperStatus','o','Text'],
				  ]
		],
		['ipAddrTable','n',[['ip','1','IP'],
				    ['mask','1','IP'],
				    ['bcast','1','IP'],
				    ['ifIndex','1','Text'],
				   ],
		],
		['routeTable','n',[['dest','1','IP'],
				   ['mask','1','IP'],
				   ['nextHop','1','IP'],
				   ['ifIndex','1','Text'],
				   ['type','1','Text'],
				  ],
		],
		['arpTable','n','IP'],
	       ],
   'Link'=>[['firsthop','1','IP'],
	    ['secondhop','1','IP'],
	    ['realfirst','o','IP'],
	    ['realsecond','o','IP'],
	    ['cost','o','OSPFcost'],
	    ['log','o','Filename'],
	   ],
  );

sub no_processing
  {my ($text) =@_;
   return "$text";}

sub init{
  # Check what all we can run on this system
  $NoPing=0;
  $NoTrace=0;
  $NoDNS=0;
  $NoNIS=0;
  $NoIfconf=0;
  $BATCHSIZE=40;
  $PING_TIMEOUT=200;
  $TRACERT_TIMEOUT=100;
  $MAX_MASK=&dotted2long('255.255.192.0');
     #(our guess of) the longest netmask that can be associated with a
     #single subnet
  $NULL_MASK=&dotted2long('0.0.0.0');
  $LOCALHOST=&dotted2long('127.0.0.1');
}

return 1;
