#!/usr/local/bin/perl
#
#

# heuristic 5, with bellcore trick to find hosts
# traceroute to determine subnets...

use strict 'refs';

require 'common.pl';
require 'dns.pl';
require 'snmpinterface.pl';
require 'ping.pl';
require 'serializer.pl';
require 'inet.pl';
require 'tracert.pl';
require 'ipmaker.pl';
require 'dbinterface.pl';
require 'links.pl';
require 'shorties.pl';
require 'logging.pl';

#The "Context variables" are variables that have dyanmic scope
#(using local). They are used to pass context information the inner
#functions.
local @ctx_dns_target=(''); #The dns domains included in the target of
     #discovery. '' matches any domain, empty list means nothing gets accepted
local $ctx_accept_nodns='1'; #accept computers with no dns entry? If set to
     #yes this takes precedence over @ctx_dns_target=()
local @ctx_ip_target=([&dotted2long('0.0.0.0'),&dotted2long('0.0.0.0')]);
     #The list of IP/netmask pairs covering the target domain. If empty
     #nothing matches if contains 0.0.0.0/0.0.0.0 anything matches
local $ctx_process_uninteresting= sub 
  {&log_message(4 ,"Uninteresting>>".&serialize('Computer',@_));
   return '';};
     #The address of the function to decide what to do with a node that falls
     #outside the target domain. If it returns true the node is added to the
     #database anyway.
local $ctx_treat_bad_lasthop = sub {return '1';};
#sub {my ($a,$b)=@_; print X "Bad default>>".&serialize('Computer',$a)."<-->".&serialize('Computer',$b)."<<\n";return '1';};
     #The address of the function to handle the case when there is a new
     #lasthop that's different from the one in the database
local $ctx_saw_other_address = sub 
  {my ($ip,$addr,$end,$gw)=@_; 
   &log_message(3,"Showed>>".&long2dotted($addr)."--instead of--".
		&long2dotted($ip)."--end--".&serialize('Computer',$end).
		"--gateway--".&serialize('Computer',$gw));
   return '';};
     #For logging when a computer shows another interface to traceroute than
     #the one which is linked to the gatweay the trace came through
local $ctx_report_weird_case = sub 
  {my ($end,$gw,$min_end,$min_gw,$subnet)=@_; 
   &log_message(4,"Weird case>>".&serialize('Computer',$end)."--".
		&long2dotted($min_end)."--".&serialize('Computer',$gw)."--".
		&long2dotted($min_gw)."--".&serialize('Subnet',$subnet))};
local $ctx_report_bad_case = sub 
  {my ($end,$gw,$min_end,$min_gw,$subnet)=@_; 
   &log_message(4,"Bad case>>".&serialize('Computer',$end)."--".
		&long2dotted($min_end)."--".&serialize('Computer',$gw)."--".
		&long2dotted($min_gw)."--".&serialize('Subnet',$subnet))};
local $ctx_subnet_method = 0; #the method used for determining subnets (0 for
     #guessing, 1 for SNMP, see common.pl)

# this is the intellegence of heuristic 5. Figures out when and where to
#  add new
# addresses.
sub add_addr {
    my ($new_addr, $addrs_handle) = @_;
    if ($added_addrs{$new_addr} == 0) {
#	print "adding to list: $new_addr\n";
	push(@$addrs_handle, $new_addr);
	$added_addrs{$new_addr} = 1;
    }
}

sub add_addrs {
    my($new_addrs, $addrs_handle) = @_;
    my($j);
    for ($j = 0; $j <= $#$new_addrs; $j++) {
	&add_addr(@$new_addrs[$j], $addrs_handle);
    }
}

sub add_correlated_addrs {
    my($new_addr, $addrs_handle) = @_;
    my $temp_addrs_handle;
    my ($j);
#    print "checking $new_addr under heuristic 5\n";
    
# if exists a "*.1" address
    if ($new_addr =~ /\A(\d+)\.(\d+)\.(\d+)\.1\Z/) {
	for ($j = 2; $j <= $persistance_factor + 2; $j++) {
	    &add_addr("$1.$2.$3.$j", $addrs_handle);
	}
	&add_addr("$1.$2.$3.129", $addrs_handle);
	@$temp_addrs_handle = '';
	&ipmaker_rand($temp_addrs_handle, "$1.$2.$3.*", $persistance_factor * 5);
	&add_addrs($temp_addrs_handle, $addrs_handle);
	
# if exists a "*.129" address
    } elsif ($new_addr =~ /\A(\d+)\.(\d+)\.(\d+)\.129\Z/) {
	for ($j = 130; $j <= $persistance_factor + 128; $j++) {
	    &add_addr("$1.$2.$3.$j", $addrs_handle);
	}
	&add_addr("$1.$2.$3.65", $addrs_handle);
  	&add_addr("$1.$2.$3.193", $addrs_handle);
# for any other address
    } elsif ($new_addr =~ /\A(\d+)\.(\d+)\.(\d+)\.(\d+)\Z/) {
	for ($j = $4 + 1; $j <= $persistance_factor + $4; $j++) {
	    &add_addr("$1.$2.$3.$j", $addrs_handle);
	}
    } else {
	print STDERR "error: $new_addr is not a valid address\n";
    }
}

########################################################################
# Settings (check the init function from common.pl too)
########################################################################
@ctx_ip_target=([&dotted2long('128.84.0.0'),&dotted2long('255.255.0.0')],
		[&dotted2long('128.253.0.0'),&dotted2long('255.255.0.0')],
		[&dotted2long('132.236.0.0'),&dotted2long('255.255.0.0')]);
@ctx_dns_target=('cs.cornell.edu');#,'utcluj.ro');

local($persistance_factor) = 5; # should be at least 2.
local($added_addrs) = '';

my ($database)='database-h2-1';
my ($alg)='h2';
my (@h5_init_patterns)=("128.84.*.1");#,"128.253.*.1","132.236.*.1");
my (@communities)=('public','secret1','secret2');
my ($h4_domain)='cs.cornell.edu';
&init;
&store_init($database);
&log_init($database);
&dns_init;
&tracert_init;
&ping_init;


if ($alg eq 'h5')
  {my $addrs = [];
   &log_message(5,"Starting h5!!!!!");
   {my$temp_addrs  = [];
    my ($j);
    # grabbing hosts from pregenerated list;
    foreach $j (@h5_init_patterns)
      {&ipmaker_all($temp_addrs, $j);}
    for ($j = 0; $j <= $#$temp_addrs; $j++) 
      {&add_addr(@$temp_addrs[$j], $addrs);}
  }
   my %visited=();
   my(@route,$k,@addrbatch,@returnbatch,$batchi,$addr);
   
   for($k=0; $k<=$#$addrs;) 
     {print "--";
      print "Checking... $addr. left = $#$addrs - $k";
      print "--\n";
      @addrbatch = ();
      @returnbatch = ();

      for ($batchi=0; $batchi<$BATCHSIZE && $k<=$#$addrs; $k++) 
	{$addr = @$addrs[$k];
	 next if ($visited{$addr} == 1);
	 $visited{$addr} = 1;
	 next if ($addr eq '');
	 $name = dns_addr2name(&dotted2long($addr));
	 next if (!&is_interesting([&dotted2long($addr)],$name));
	 push @addrbatch, $addr;
	 $batchi++;
       }

      print ">>>>\n";
      @returnbatch = &bping_alive($PING_TIMEOUT,@addrbatch);
      print "<<<<\n";

      foreach $addr (@returnbatch) 
	{&add_correlated_addrs($addr, $addrs);
	 $laddr=&dotted2long($addr);
	 &store_computer($laddr);
	 @route = &tracert($addr, $TRACERT_TIMEOUT);
	 if ($#route < 1) {next;}
	 my ($m);
	 for ($m=0;$m<=$#route;$m++)
	   {$route[$m]=&dotted2long($route[$m]);}

	 for ($m=1;$m<=$#route;$m++)
	   {$a=&store_computer($route[$m-1]);
	    $b=&store_computer($route[$m]);
	    if ($a == $b)
	      {&log_message(3, "Looping router $a");
	       last;}
	    &add_link($a,$b,$route[$m]);
	  }
       }
    }
 }
elsif ($alg eq 'h4')
  {my $addrs;
   &log_message (5,"Starting h4 at". time);
   $addrs=&rec_dns($h4_domain);
   &log_message (5,"Got all addresses at". time);
   my %visited=();
   my(@route,$k,@addrbatch,@returnbatch,$batchi,$addr);
   
   for($k=0; $k<=$#$addrs;) 
     {print "--";
      print "Checking... ".&long2dotted($addr).". left = $#$addrs - $k";
      print "--\n";
      @addrbatch = ();
      @returnbatch = ();

      for ($batchi=0; $batchi<$BATCHSIZE && $k<=$#$addrs; $k++)
	{$addr = @$addrs[$k];
	 next if ($visited{$addr} == 1);
	 $visited{$addr} = 1;
	 next if ($addr eq '');
	 $name = dns_addr2name($addr);
	 next if (!&is_interesting([$addr],$name));
	 push @addrbatch, &long2dotted($addr);
	 $batchi++;
       }

      print ">>>>\n";
      @returnbatch = &bping_alive($PING_TIMEOUT,@addrbatch);
      print "<<<<\n";

      foreach $addr (@returnbatch) 
	{#&add_correlated_addrs($addr, $addrs);
	 $laddr=&dotted2long($addr);
	 &store_computer($laddr);
	 @route = &tracert($addr, $TRACERT_TIMEOUT);
	 if ($#route < 1) {next;}
	 my ($m);
	 for ($m=0;$m<=$#route;$m++)
	   {$route[$m]=&dotted2long($route[$m]);}

	 for ($m=1;$m<=$#route;$m++)
	   {$a=&store_computer($route[$m-1]);
	    $b=&store_computer($route[$m]);
	    if ($a == $b)
	      {&log_message(3, "Looping router $a");
	       last;}
	    &add_link($a,$b,$route[$m]);
	  }
       }
    }
   &log_message(5,"Done all probing at". time);
 }
elsif ($alg eq 'h2')
  {my %visited=();

   my(@routers) = &tracert('132.236.218.11', $TRACERT_TIMEOUT*50);
   for ($m=0;$m<=$#routers;$m++)
     {$routers[$m]=&dotted2long($routers[$m]);}

   my ($k);
print "Got it!\n";
   for($k=0;$k<=$#routers;$k++)
     {my ($router)=$routers[$k];
      next if ($visited{$router});
      $visited{$router}='1';
      my $id=&store_computer($router);
      if ($id)
	{print "SNMP-ing $Computer[$id]->[1]->[0], $#routers-$k left..\n";
	 &log_message(4, "SNMP-ing $Computer[$id]->[1]->[0], $#routers-$k left..");
	 my $snmpdata=&detailed_mib2_query(&long2dotted($router),@communities);
	 print "Done.\n";
         unless ($snmpdata)
	   {my $ip;
	    foreach $ip (@{$Computer[$id]->[0]})
	      {$visited{$ip}='1'}
	    next;
	  }
	 unless (&add_snmp_data($router,$snmpdata))
	   {print "Problems with $router\n";}
         my($ip);
	 foreach $ip (@{$Computer[$id]->[0]})
	   {$visited{$ip}='1';}
         my($comp);
         foreach $comp (@{$snmpdata->[5]})
	   {&store_computer($comp)}
         my @others=();
         foreach $comp (map {$_->[2]} @{$snmpdata->[4]})
	   {if (!grep {$_ eq $comp} @others)
	      {push @others,$comp;}
	  }
	 foreach $comp (@others)
	   {if (!$visited{$comp})
	      {push @routers, $comp;}
	  }
       }
    }

#   print join ("\n",@route)."\n";
 }
&ping_print_stats();
&tracert_print_stats();
&dns_print_stats();

print "Database directory $database, algorithm $alg.\n";

print time."\n";

open (F,">$database/Computer");

print "Starting with $#Computer computers\n";
$i=0;
while ($#Computer>=0)
  {print F  $i++.&serialize('Computer',$Computer[0]); 
   print F  "\n";
   shift @Computer;
 }

close F;

print "Done with computers\n";

print "Starting with $#Subnet subnets\n";
open (F,">$database/Subnet");
$i=0;
while ($#Subnet>=0)
  {print F $i++.&serialize('Subnet',$Subnet[0]); 
   print F "\n";
   shift @Subnet;
 }

close F;
print "Done with subnets\n";

print "Starting with $#SNMPdata SNMP\n";
open (F,">$database/SNMPdata");
$i=0;
while ($#SNMPdata>=0)
  {print F $i++.&serialize('SNMPdata',$SNMPdata[0]); 
   print F "\n";
   shift @SNMPdata;
 }

close F;
print "Done with SNMP\n";

print time."\n";
