package uk.ac.soton.harvester;
import java.io.*;

/**
 * harness is a driver class that creates a citation harvesting object 
 * and applies it to a specific data file.
 * @author Leslie A Carr
 * @version 1.0
 */
public class harness
{
    /**
     * getCitations performs citation harvesting on a specific data file.
     * @param pdfFile the data file to be interpreted. This is not in fact
     *        a file in PDF formal, but an intermediate XML format directly
     *	      produced from the PDF by an independent program (currently bpe5).
     * @param articleId a string which uniquely identifies the articles.
     *        The string will conform to the pattern PP-JJ-STUFF where
     *	      PP is a two-letter publisher code, JJ is a two-letter journal
     *        code and STUFF is an uninterpreted article code. The substring
     *        PP-JJ uniqueli identifies a particular journal.
     * @param xmlFile the name of a file to which XML data will be written
     *	      containing the citation data extracted from the article.
     *	      The XML conforms to the Ingenta DTD.
     * @param options an array of strings (just the arguments passed to
     *        the main method) which contains a list of hints on how to
     *        best parse the article.
     */
    static int getCitations(String pdfFile, String articleId, String xmlFile, String options[])
							throws Exception {
	com.bids.jol.loaders.CitationsHarvester h=new OUTHarvester();
	FileWriter f=new FileWriter(xmlFile);

	h.setInputFile(new File(pdfFile));
	h.setArticleId(articleId);
	h.setOptions(options);

	return h.harvest(new BufferedWriter(f));
	}

    /**
     * main is the driver for the citation processing.
     * It takes input and output file names from the command line
     * along with (optional) article id and a set of hints for processing.
     */
    public static void main(String args[]) throws Exception{
	if(args.length<2)
		System.err.println("usage: harness infile outfile [docid [hints]]");
	else{
		String inf, outf, docid;
		int result;

		inf=args[0];
		outf=args[1];
		if(args.length>2)docid=args[2];
		else docid="?id?";

		result=getCitations(inf, docid, outf, args);
		System.out.println("There were "+result+" citations.");
		}
	}
}
