package uk.ac.soton.harvester;
import java.io.*;

/**
 *
 * XMLOutput puts the citation data onto the specified printwriter
 * in XML format.
 * Modified at Cornell to emit an optional URL address - djb (6/2000)
 **/
class XMLOutput extends CitationOutput {

	XMLOutput(DeciterState ds){
		super(ds);
		}

	void pre(PrintWriter out){
		out.println("<?xml version='1.0'?>");
		out.println("<!DOCTYPE citations PUBLIC '-//Ingenta//Citation Harvesting DTD v1.1//EN' '../bin/citations.dtd'>");
		out.println("<citations documentid='"+ds.documentid+"'>");
		}

	void post(PrintWriter out){
		out.println("</citations>");
		}

	String output(PrintWriter out){

		prepare();

		String line=ds.line;
		int maxi=line.length()-1;

		Utils.DEBUG("Q");

		boolean isBook=Utils.isBook(ds);

		//out.println("<!-- '"+ds.line+"' -->");
		//out.println("<!-- NUM, AUTH, TITLE "+ds.digb+" "+ds.dige+" "+ds.authb+" "+ds.authe+" "+ds.titb+" "+ds.tite+" -->");
		out.println("<citation>");
		if(isBook)out.println("<book>");
		else out.println("<article>");
		out.println("<authors>");
		splitAuthors(author, ds, out);
		out.println("</authors>");
		out.println("<title>"+Utils.PCDATA(tit)+"</title>");
		if(isBook){
			out.println("<publisher>");
			out.println("<name>"+Utils.PCDATA(publish)+"</name>");
			out.println("<place>"+Utils.PCDATA(place)+"</place>");
			//out.println("<!-- MISC '"+Utils.PCDATA(misc)+"' -->");
			out.println("</publisher>");
			}
		if(ds.xxxHint && ds.xxxb>0)out.println("<xxxid>"+xxxid+"</xxxid>");
		// added by djb to print out optional url (displayID)
		if(ds.urlb != -1 && ds.urle != -1)
		   out.println("<displayID>"+Utils.PCDATA(url)+"</displayID>");
		if(isBook)out.println("</book>");
		else out.println("</article>");
		if(!isBook){
			out.println("<journal>");
			out.println("<title>"+Utils.PCDATA(pub)+"</title>");
			out.println("<year>"+date+"</year>");
			out.print("<volume>"+vol+"</volume>");
			out.println("<issue>"+iss+"</issue>");
			splitPages(pages, out);
			out.println("</journal>");
			}
		out.println("</citation>");
		out.println();

		return rest;
		}

	}

