package uk.ac.soton.harvester;
import java.io.*;

/**
 *
 * TXTOutput puts the citation data onto the specified printwriter
 * in plain ASCII text format.
 **/
class TXTOutput extends CitationOutput {

	TXTOutput(DeciterState ds){
		super(ds);
		}

	String output(PrintWriter out){
		prepare();

		Utils.DEBUG("N");

		out.println("Author:\t"+author);
		splitAuthors(author, ds, out);
		out.println("Date:\t"+date);
		out.println("Title:\t"+tit);
		out.println("Publ:\t"+pub);
		out.println("Volume:\t"+vol);
		out.println("Issue:\t"+iss);
		out.println("Pages:\t"+pages);
		if(xxxid!=null)out.println("XXX:\t"+xxxid);
		splitPages(pages, out);
		out.println();

		return rest;
		}
	}

