package uk.ac.soton.harvester;
import java.io.*;

/**
 * The OUTHarvester class sets up the environment for the real
 * citation processing. It opens the input and output files
 * and then creates a deciter object to handle the real work.
 */
public class OUTHarvester implements com.bids.jol.loaders.CitationsHarvester {

	/**
         * in simply holds a reference to the input reader.
         */
	BufferedReader in=null;

	/**
         * inFile holds the file to which the input reader
         * is to be connected.
         */
	File inFile=null;

	/**
         * id holds the identifier of the current article
         */
	String id=null;

	/**
         * options holds the set of hints that control the deciter
         * process. It also holds all other options passed on the
         * command line, and relies on the fact that the hints
         * are uniquely recognisable.
         */
	String options[]=null;

	/**
	 * setInputFile sets the value of <tt>inFile</tt> and
	 * tries to open a <tt>BufferedReader</tt> on that file.
	 * @param inputFile the File object to which a Reader is to be opened.
	 * @throws FileNotFoundException if the file is non-existent
	 */
	public void setInputFile(File inputFile) throws FileNotFoundException{
		if(inputFile==null)
			throw new Error("Null file specified");
		inFile = inputFile;
		in = new BufferedReader(new FileReader(inputFile));
		}

	/**
	 * setArticleId sets the article id
	 * @param aid the id to be used for this article
	 */
	public void setArticleId(String aid){
		if(aid==null || aid.length()==0)
			throw new Error("Null id specified");
		id=aid;
		}

	/**
	 * getInputFile accessor method for inFile
	 * @return File object to which the Reader is connected
	 */
	public File getInputFile(){
		return inFile;
		}
	

	/**
	 * getArticleId accessor method for the id
	 * @return id of the current article
	 */
	public String getArticleId(){
		return id;
		}

	/**
	 * store the options (i.e.&nbsp;processing hints) for the deciter to
	 * use and change its behaviour.
	 * This is a little loose: it relies on the fact that the options
	 * processer in the deciter class ignores any options it doesn't
	 * recognise, hence will ignore the file names.
	 * @param opts array of string options as passed on the command line
	 */
	public void setOptions(String opts[]){
		this.options=opts;
		}

	/**
	 * Create the appropriate readers and writers, make a deciter
	 * object, set its hints/options and invoke its <tt>doit</tt>
	 * method to make it to do the dirty work.
	 */
	public int harvest(BufferedWriter xmlOutput) throws IOException{
		if(id==null)
			throw new Error("Attempt to harvest without ID set");
		if(in==null)
			throw new Error("Attempt to harvest without input set");

		//This is now handled explicitly in the deciter
		//Because you have to handle tag delimiters differently from
		// '<' inside the content.
		//PrintWriter outp=new EntityWriter(xmlOutput);
		PrintWriter outp=new PrintWriter(xmlOutput);

		//However, all occurrences of entities must be processed
		BufferedReader inp=new EntityReader(in);

		Deciter deci=new Deciter(id, options);
		return deci.doit(inp, outp);
		}
	}
