package uk.ac.soton.harvester;
/**
 * ISOLatRevHashTable is the inverse of
 * ISOLatHashTable, and  provides a hash table which is
 * already filled in with an inverse mapping between the
 * ISOLatin-1 entity names and the character
 * positions by which they are represented.
 * Each key is a 1-character String (<i>e.g.</i> "\x00c0")
 * whose first character is the ASCII position
 * represented by the entity named by the
 * associated value (<i>e.g.</i> "Agrave").
 */
class ISOLatRevHashTable extends java.util.Hashtable {
	/**
	 * Default constructor creates the pre-filled HashTable.
	 */
	ISOLatRevHashTable(){
		//True ISOLatin1
		this.put(""+(char)160, "nbsp");
		this.put(""+(char)161, "iexcl");
		this.put(""+(char)162, "cent");
		this.put(""+(char)163, "pound");
		this.put(""+(char)164, "curren");
		this.put(""+(char)165, "yen");
		this.put(""+(char)166, "brvbar");
		this.put(""+(char)167, "sect");
		this.put(""+(char)168, "uml");
		this.put(""+(char)169, "copy");
		this.put(""+(char)170, "ordf");
		this.put(""+(char)171, "laquo");
		this.put(""+(char)172, "not");
		this.put(""+(char)173, "shy");
		this.put(""+(char)174, "reg");
		this.put(""+(char)175, "macr");
		this.put(""+(char)176, "deg");
		this.put(""+(char)177, "plusmn");
		this.put(""+(char)178, "sup2");
		this.put(""+(char)179, "sup3");
		this.put(""+(char)180, "acute");
		this.put(""+(char)181, "micro");
		this.put(""+(char)182, "para");
		this.put(""+(char)183, "middot");
		this.put(""+(char)184, "cedil");
		this.put(""+(char)185, "sup1");
		this.put(""+(char)186, "ordm");
		this.put(""+(char)187, "raquo");
		this.put(""+(char)188, "frac14");
		this.put(""+(char)189, "frac12");
		this.put(""+(char)190, "frac34");
		this.put(""+(char)191, "iquest");
		this.put(""+(char)192, "Agrave");
		this.put(""+(char)193, "Aacute");
		this.put(""+(char)194, "Acirc");
		this.put(""+(char)195, "Atilde");
		this.put(""+(char)196, "Auml");
		this.put(""+(char)197, "Aring");
		this.put(""+(char)198, "AElig");
		this.put(""+(char)199, "Ccedil");
		this.put(""+(char)200, "Egrave");
		this.put(""+(char)201, "Eacute");
		this.put(""+(char)202, "Ecirc");
		this.put(""+(char)203, "Euml");
		this.put(""+(char)204, "Igrave");
		this.put(""+(char)205, "Iacute");
		this.put(""+(char)206, "Icirc");
		this.put(""+(char)207, "Iuml");
		this.put(""+(char)208, "ETH");
		this.put(""+(char)209, "Ntilde");
		this.put(""+(char)210, "Ograve");
		this.put(""+(char)211, "Oacute");
		this.put(""+(char)212, "Ocirc");
		this.put(""+(char)213, "Otilde");
		this.put(""+(char)214, "Ouml");
		this.put(""+(char)215, "times");
		this.put(""+(char)216, "Oslash");
		this.put(""+(char)217, "Ugrave");
		this.put(""+(char)218, "Uacute");
		this.put(""+(char)219, "Ucirc");
		this.put(""+(char)220, "Uuml");
		this.put(""+(char)221, "Yacute");
		this.put(""+(char)222, "THORN");
		this.put(""+(char)223, "szlig");
		this.put(""+(char)224, "agrave");
		this.put(""+(char)225, "aacute");
		this.put(""+(char)226, "acirc");
		this.put(""+(char)227, "atilde");
		this.put(""+(char)228, "auml");
		this.put(""+(char)229, "aring");
		this.put(""+(char)230, "aelig");
		this.put(""+(char)231, "ccedil");
		this.put(""+(char)232, "egrave");
		this.put(""+(char)233, "eacute");
		this.put(""+(char)234, "ecirc");
		this.put(""+(char)235, "euml");
		this.put(""+(char)236, "igrave");
		this.put(""+(char)237, "iacute");
		this.put(""+(char)238, "icirc");
		this.put(""+(char)239, "iuml");
		this.put(""+(char)240, "eth");
		this.put(""+(char)241, "ntilde");
		this.put(""+(char)242, "ograve");
		this.put(""+(char)243, "oacute");
		this.put(""+(char)244, "ocirc");
		this.put(""+(char)245, "otilde");
		this.put(""+(char)246, "ouml");
		this.put(""+(char)247, "divide");
		this.put(""+(char)248, "oslash");
		this.put(""+(char)249, "ugrave");
		this.put(""+(char)250, "uacute");
		this.put(""+(char)251, "ucirc");
		this.put(""+(char)252, "uuml");
		this.put(""+(char)253, "yacute");
		this.put(""+(char)254, "thorn");
		this.put(""+(char)255, "yuml");

		//Extended and Misc Bits 
		this.put(""+(char)38, "amp");
		this.put(""+(char)60, "lt");
		this.put(""+(char)62, "gt");
		this.put(""+(char)338, "OElig");
		this.put(""+(char)339, "oelig");
		this.put(""+(char)352, "Scaron");
		this.put(""+(char)353, "scaron");
		this.put(""+(char)376, "Yuml");
		this.put(""+(char)8211, "ndash");
		this.put(""+(char)8212, "mdash");
		this.put(""+(char)8216, "lsquo");
		this.put(""+(char)8217, "rsquo");
		this.put(""+(char)8218, "sbquo");
		this.put(""+(char)8220, "ldquo");
		this.put(""+(char)8221, "rdquo");
		}
	}
