package uk.ac.soton.harvester;
/**
 * ISOLatHashTable provides a hash table which is
 * already filled in with a mapping between the
 * ISOLatin-1 entity names and the character
 * positions by which they are represented.
 * The key is a String, <i>e.g.</i> "Agrave"
 * and the associated value is a 1-character String
 * whose first character is the ASCII position
 * represented by the entity.
 */
class ISOLatHashTable extends java.util.Hashtable {

	/**
	 * Default constructor creates the pre-filled
	 * HashTable.
	 */
	ISOLatHashTable(){
		//True ISOLatin1
		this.put( "nbsp", "" + (char)160 );
		this.put( "iexcl", "" + (char)161 );
		this.put( "cent", "" + (char)162 );
		this.put( "pound", "" + (char)163 );
		this.put( "curren", "" + (char)164 );
		this.put( "yen", "" + (char)165 );
		this.put( "brvbar", "" + (char)166 );
		this.put( "sect", "" + (char)167 );
		this.put( "uml", "" + (char)168 );
		this.put( "copy", "" + (char)169 );
		this.put( "ordf", "" + (char)170 );
		this.put( "laquo", "" + (char)171 );
		this.put( "not", "" + (char)172 );
		this.put( "shy", "" + (char)173 );
		this.put( "reg", "" + (char)174 );
		this.put( "macr", "" + (char)175 );
		this.put( "deg", "" + (char)176 );
		this.put( "plusmn", "" + (char)177 );
		this.put( "sup2", "" + (char)178 );
		this.put( "sup3", "" + (char)179 );
		this.put( "acute", "" + (char)180 );
		this.put( "micro", "" + (char)181 );
		this.put( "para", "" + (char)182 );
		this.put( "middot", "" + (char)183 );
		this.put( "cedil", "" + (char)184 );
		this.put( "sup1", "" + (char)185 );
		this.put( "ordm", "" + (char)186 );
		this.put( "raquo", "" + (char)187 );
		this.put( "frac14", "" + (char)188 );
		this.put( "frac12", "" + (char)189 );
		this.put( "frac34", "" + (char)190 );
		this.put( "iquest", "" + (char)191 );
		this.put( "Agrave", "" + (char)192 );
		this.put( "Aacute", "" + (char)193 );
		this.put( "Acirc", "" + (char)194 );
		this.put( "Atilde", "" + (char)195 );
		this.put( "Auml", "" + (char)196 );
		this.put( "Aring", "" + (char)197 );
		this.put( "AElig", "" + (char)198 );
		this.put( "Ccedil", "" + (char)199 );
		this.put( "Egrave", "" + (char)200 );
		this.put( "Eacute", "" + (char)201 );
		this.put( "Ecirc", "" + (char)202 );
		this.put( "Euml", "" + (char)203 );
		this.put( "Igrave", "" + (char)204 );
		this.put( "Iacute", "" + (char)205 );
		this.put( "Icirc", "" + (char)206 );
		this.put( "Iuml", "" + (char)207 );
		this.put( "ETH", "" + (char)208 );
		this.put( "Ntilde", "" + (char)209 );
		this.put( "Ograve", "" + (char)210 );
		this.put( "Oacute", "" + (char)211 );
		this.put( "Ocirc", "" + (char)212 );
		this.put( "Otilde", "" + (char)213 );
		this.put( "Ouml", "" + (char)214 );
		this.put( "times", "" + (char)215 );
		this.put( "Oslash", "" + (char)216 );
		this.put( "Ugrave", "" + (char)217 );
		this.put( "Uacute", "" + (char)218 );
		this.put( "Ucirc", "" + (char)219 );
		this.put( "Uuml", "" + (char)220 );
		this.put( "Yacute", "" + (char)221 );
		this.put( "THORN", "" + (char)222 );
		this.put( "szlig", "" + (char)223 );
		this.put( "agrave", "" + (char)224 );
		this.put( "aacute", "" + (char)225 );
		this.put( "acirc", "" + (char)226 );
		this.put( "atilde", "" + (char)227 );
		this.put( "auml", "" + (char)228 );
		this.put( "aring", "" + (char)229 );
		this.put( "aelig", "" + (char)230 );
		this.put( "ccedil", "" + (char)231 );
		this.put( "egrave", "" + (char)232 );
		this.put( "eacute", "" + (char)233 );
		this.put( "ecirc", "" + (char)234 );
		this.put( "euml", "" + (char)235 );
		this.put( "igrave", "" + (char)236 );
		this.put( "iacute", "" + (char)237 );
		this.put( "icirc", "" + (char)238 );
		this.put( "iuml", "" + (char)239 );
		this.put( "eth", "" + (char)240 );
		this.put( "ntilde", "" + (char)241 );
		this.put( "ograve", "" + (char)242 );
		this.put( "oacute", "" + (char)243 );
		this.put( "ocirc", "" + (char)244 );
		this.put( "otilde", "" + (char)245 );
		this.put( "ouml", "" + (char)246 );
		this.put( "divide", "" + (char)247 );
		this.put( "oslash", "" + (char)248 );
		this.put( "ugrave", "" + (char)249 );
		this.put( "uacute", "" + (char)250 );
		this.put( "ucirc", "" + (char)251 );
		this.put( "uuml", "" + (char)252 );
		this.put( "yacute", "" + (char)253 );
		this.put( "thorn", "" + (char)254 );
		this.put( "yuml", "" + (char)255 );

		//Extended and Misc Bits
		this.put( "amp", "" + (char)38 );
		this.put( "lt", "" + (char)60 );
		this.put( "gt", "" + (char)62 );
		this.put( "OElig", "" + (char)338 );
		this.put( "oelig", "" + (char)339 );
		this.put( "Scaron", "" + (char)352 );
		this.put( "scaron", "" + (char)353 );
		this.put( "Yuml", "" + (char)376 );
		this.put( "ndash", "" + (char)8211 );
		this.put( "mdash", "" + (char)8212 );
		this.put( "lsquo", "" + (char)8216 );
		this.put( "rsquo", "" + (char)8217 );
		this.put( "sbquo", "" + (char)8218 );
		this.put( "ldquo", "" + (char)8220 );
		this.put( "rdquo", "" + (char)8221 );
		}
	}
