package uk.ac.soton.harvester;
import java.io.*;
import java.util.*;

/**
 * EntityWriter extends the behaviour of <tt>PrintWriter</tt>
 * so that any non-ASCII characters are printed by their
 * ISO-Latin-1 entity names.
 * This class accompanies <tt>EntityReader</tt> to allow
 * the processor to read data in from and write data out
 * to XML-based files.
 */
public class EntityWriter extends PrintWriter {

	/**
	 * d provides a reverse lookup from character number
	 * to entity name
	 */
	Dictionary d=new ISOLatRevHashTable();

	/**
	 * The main constructor allows an <tt>EntityWriter</tt>
	 * to be based on any kind of <tt>BufferedWriter</tt>.
	 */
	EntityWriter(BufferedWriter b){
		super(b);
		}


	/**
	 * entName is a wrapper function which guarantees a safe
	 * name for a character position. It defaults to
	 * "unknown" for pathalogical cases.
	 * @param ch character value to look up
	 * @return ISOLatin-1 entity name of the character parameter
	 * (or "unknown" in pathalogical cases).
	 */
	String entName(char ch){
		// System.err.println("Denaming "+(int)ch+" ("+ch+")");
		String result;
		result=(String)d.get(""+ch);
		if(result==null)result="unknown";
		return result;
		}

	/**
	 * entString encodes any unusual characters in a string as
	 * ISOLAtin-1 entities. Ordinary ASCII characters are
	 * left untouched. Some "ordinary" characters ('&','<','>')
	 * have to be usurped to conform to the XML standard.
	 * <i>e.g.</i> "Carr & Ren" is transformed into
	 * "Carr &amp;mp; Ren&amp;eacute;" .
	 * @param s the string to process
	 * @return the string with embedded characters replaced by
	 * entity names
	 */
	String entString(String s){
		StringBuffer s1=new StringBuffer();
		int c;

		for(c=0; c<s.length(); c++){
			char ch=s.charAt(c);
			if(ch=='&') s1.append("&amp;");
			else if(ch=='<') s1.append("&lt;");
			else if(ch=='>') s1.append("&gt;");
			else if(((int)ch)>=32 && ((int)ch)<127) s1.append(ch);
			else s1.append("&"+entName(ch)+";");
			// else s1.append("&#"+(int)ch+";");
			}
		return(s1.toString());
		}

	/**
	 * println prints an entity-encoded version of its parameter.
	 * @param s the String to print
	 */
	public void println(String s){
		super.println(entString(s));
		super.flush();
		}

	}
