package uk.ac.soton.harvester;
/**
 *
 * doXXXId tries to recognise the appearance of an XXX eprint identifier
 * within a string. It sets sets xxx[be] if successful.
 *
**/
public class DoXXXId implements AttributeMarker {
	public int markAttribute(DeciterState ds, int i){
		String line=ds.line;
		int maxi=line.length()-1;
		int slash=0;
		boolean found=false;

		while(!found && (slash=line.indexOf('/',slash+1))>-1){
			int c;
			for(c=slash-1; c>=0 && Utils.lowercaseOrHyphen(line,c); c--); 
			if(Utils.xxxId(line.substring(c+1))){
				ds.xxxb=c+1;
				ds.xxxe=slash+7;
				i=slash+8;
				found=true;
				}
			}

		//RESOLVE CONFLICT BETWEEN PAGE # AND VOL/ISSUE
		if(ds.pagb<0){
			if(ds.issb>0 && ds.isse>0){
				ds.pagb=ds.issb;
				ds.page=ds.isse;
				ds.issb=ds.isse=-1;
				}
			}
		if(ds.volb>=ds.xxxb && ds.vole<=ds.xxxe){
			ds.volb=-1; ds.vole=-1;
			}

		return i;
		}
	}
