package uk.ac.soton.harvester;
/**
 *
 * doVolAndIssue uses the settings of miscb and misce (arranged by
 * doPageRange) and looks inside that range for the journal volume
 * and issue substrings.
 *
**/
public class DoVolAndIssue implements AttributeMarker {
	public int markAttribute(DeciterState ds, int i){
		String line=ds.line;
		int maxi=line.length()-1;
		char ch;
		int j;

		//proceedings don't have vol/iss numbers
		//and they may well scam the year or page number
		//if they try!
		if(Utils.isProceedings(ds))return i;

		if(ds.miscb<0 || ds.misce<0)return i;
		Utils.DEBUG("J '"+line.substring(ds.miscb, ds.misce+1)+"'");
   		for(j=ds.miscb; j<=ds.misce && !Character.isDigit(line.charAt(j)); j++);
		if(j<=ds.misce){
			Utils.DEBUG("K "+j+" "+ds.miscb+" "+ds.misce+" "+line.length());
			ds.volb=j++;
			while(j<=ds.misce && Character.isDigit(line.charAt(j)))j++;
			ds.vole=j-1;

			while(j<=ds.misce && !Character.isDigit(line.charAt(j)))j++;
			if(j<=ds.misce){
				Utils.DEBUG("L");
				ds.issb=j++;
				while(j<maxi && Character.isDigit(line.charAt(j)) && j<=ds.misce)j++;
				ds.isse=j-1;
				}
			}

                Utils.DEBUG("VI="+ds.volb+","+ds.vole);
                Utils.DEBUG("ISS="+ds.issb+","+ds.isse);
 
		return i;
		}
	}


