package uk.ac.soton.harvester;
/**
 *
 * doNumbering recognises the (possible) numbering scheme prefix for
 * the citations. Usually of the form "[n] " or "n. ".
 * The purpose of this class is to set digb and dige.
 *
 * DJB: some tags are of the form [some-acronym]
 *
**/
public class DoNumbering implements AttributeMarker {
	public int markAttribute(DeciterState ds, int i){
		char ch;
		String line=ds.line;
		int maxi=line.length()-1;

		Utils.DEBUG("NUM: "+i+" ->"+line.charAt(i)+"<-");
                while(i<=maxi && Character.isWhitespace(line.charAt(i)))i++;
 
		if(line.charAt(i)=='[' ) { // djb check both letters & digits
		   if ( Character.isDigit(line.charAt(i++))) { // Do digits
			i++;

		        if(Character.isDigit(ch=line.charAt(i))){
			   ds.digb=i;
			   while(i<maxi && Character.isDigit(ch=line.charAt(i)))i++;
			   ds.dige=i-1;
			   if(ch=='.')i++;
			   if(ch==']')i++;
			}
		   } else {                   // Do characters
		      ds.digb = i;            // [
		      ds.dige = line.indexOf(']');
		      if ( ds.dige != -1 ) i = ds.dige+1;  // past ]
		      else { ds.digb=-1; i++; }  // digb=dige=-1.
		   }
		}
		Utils.DEBUG("Denumber: '"+ds.digb+" "+ds.dige+"' ->"+line.substring(i));


		// now jump over white space and tag
		if(i>=maxi)return i;
                ch = line.charAt(i);
		while(i<maxi && Character.isWhitespace(ch=line.charAt(i)))i++;
		if(ch=='<'){
			while(i<maxi && (ch=line.charAt(i))!='>')i++;
			i++;
			}
		while(i<maxi && Character.isWhitespace(ch=line.charAt(i)))i++;
		return i;
		}
	}

