package uk.ac.soton.harvester;
/**
 *  AttributeMarker is an interface that models the phenomenon
 *  of an object that knows how to look for a particular attribute
 * of a citation (title, author, volume etc). An AttributeMarker
 * object is expected to be constructed with a reference to the calling
 * deciter object, so that it can access all the variables.
 * (This is not very pretty and should be done via interfaces and accessor
 * methods, but time presses.)
 */
public interface AttributeMarker {
	/**
 	 * @param ds the deciter state object containing the current line
	 *	  and all the marker values
 	 * @param i the offset in the citation line to start searching from
 	 * @return the offset at which the next search should start
	**/
	public int markAttribute(DeciterState ds, int i);
	}
