// bergmark - december 2000 - Reference Linking Project

package Linkable.Utility;

// GetStream -

// Given the URL of a document, access it (run JTidy is HTML) and
// be prepared to return a stream of XHTML bytes.  (TBD)  
// For now it yields the document as a single string.

import java.net.*;
import java.io.*;

public class GetStream {
  
   private static final String ME = "GetStream: ";
   private static final boolean DEBUG = false;

   private String myURL;

   public GetStream ( String url ) {
      super();
      myURL = url;
   }

   // Connect to this url for analysis of an HTML document
   private static URLConnection openURL ( String url ) {
   URLConnection result = null;
      try {
         //result = (HttpURLConnection)(new URL(url).openConnection());
         result = (URLConnection)(new URL(url).openConnection());
	 System.err.println(ME+" connection to URL " + url );
	 return result;
      } catch ( IOException e ) {
	 System.err.println (ME+" cannot open URL " + url + "!");
	 System.exit(0);
         return result;  // just to help the compiler out :-)
      }
   }

   // Open this URL Connection
   private static InputStreamReader openConn ( URLConnection conn ) {
   InputStream instream = null;
      try {
         instream = conn.getInputStream();
         System.err.println(ME+" got input stream ");
         return new InputStreamReader ( instream );
      } catch ( IOException e ) {
         System.err.println (ME+" cannot open this URL!");
         System.exit(0);
         return null;  // just to help the compiler out :-)
      }
   }

   // Create a buffered reader
   private static BufferedReader buffer ( InputStreamReader in, int k ) {
      try {
         return ( new BufferedReader ( in, k ) );
      } catch ( IllegalArgumentException e ) {
         System.err.println(ME+"cannot open a buffered reader with "
         + " a buffer of size " + k);
         return ( new BufferedReader ( in ) );
      }
   }

   // Read the HTML (blocking)
   public static String readInputStream ( String u ) {

      // open the URL connection and put a buffered reader on it
      URLConnection connection = openURL( u );
      InputStreamReader in = openConn ( connection );
      int k = connection.getContentLength();
      BufferedReader br = buffer ( in, k );

      // read the document into a char[] array
      char[] result = new char[k];
      int offset = 0;
      int i = 0;
      try {
         while ( offset+1 < k && 
            (i = br.read ( result, offset, k )) != -1 ) offset += i;
         br.close();
      } catch (IOException e) {
         System.err.println(ME+"get IOException while trying to read in"
         + " from url " + u + "\n" + e.toString() );
      } catch (Exception e) {
         System.err.println(ME+"caught exception while trying to read in"
         + " from url " + u + "\n" + e.toString() );
      }

      return new String(result);
   }

} // ends class GetStream
