// bergmark -June 2000 - Reference Linking Project

// GenXML - a set of static utility functions for generating
// XML related to reference linking

// Modifications:
// 2000-08-01: Output the title as PCDATA
// 2000-09-26: Output Dublin Core rather than OAMS, and displayID is a Vector
// 2000-12-14: Be sure to entify the URN before it is written out as XML

package Linkable.Utility;

import uk.ac.soton.harvester.Utils;     // for PCDATA

import java.util.Vector;

public class GenXML {

   /**
     * Generate Dublin Core information for this item/work
     */
   public static String dc ( String title, String date,
      String myURN, Vector displayID, String doi,
      Author[] authors, String pad ) {
      if ( myURN != null && myURN !="" ) myURN=Utils.PCDATA(myURN);
      return
      pad + "<dc:title>\n" +
      pad + (title != null?Utils.PCDATA(title.replace('\n',' ')):"null") 
          + "\n"+pad+"</dc:title>\n" +
      pad + "<dc:date>"+date+"</dc:date>\n" +
             (doi != null && !doi.equals("")?
      pad + "<dc:identifier>doi:"+doi+"</dc:identifier>\n":"" )+
      pad + "<dc:identifier>urn:"+myURN+"</dc:identifier>\n" +
      dcDisplayID(pad, displayID) +
      createAuthorList (authors, pad);
   }

   // NOTE: no longer used
   public static String oams ( String title, String date,
      String myURN, String displayID, Author[] authors, String pad ) {

      return
      pad + "<oams:oams xmlns:oams=" +
      "\"http://www.openarchives.org/sfc/src_oams.htm\">\n" +
      pad + "<oams:title>\n" 
	  + (title != null?Utils.PCDATA(title.replace('\n',' ')):"null") 
	  + "\n</oams:title>\n" +
      pad + "<oams:accession accession=\""+date+"\" />\n" +
      pad + "<oams:discovery discovery=\""+date+"\" />\n" +
      pad + "<oams:fullID>"+myURN+"</oams:fullID>\n" +
      oamsDisplayID(pad, displayID) +
      createAuthorList (authors, pad) +
      pad + "</oams:oams>\n";

   }

   // Generate one reflink element for this list of URLs
   // If there are no URLS, return the empty string
   public static String urlList2xlink ( int ord, String orig, String author, 
   String title, String year, String[] urlList, String anchor ) {

      StringBuffer result = new StringBuffer("<reflist ord=\""+ord);
      if ( ! author.startsWith("*") ) result.append(" author=\""+author+"\"");
      if ( title != null && ! title.startsWith("*") ) result.append("\n" 
		   + "title=\""+title+"\"");
      if ( !year.startsWith("*")) result.append("\nyear=\""+
	 year.substring(0,4)+"\">");
      // output a url element for each element in the urlList
      if (urlList != null)
         for (int i=0; i<urlList.length; i++) 
            result.append("\nurl=\""+urlList[i]+"\"");
      result.append("\nliteral=\""+Utils.PCDATA(orig.replace('\n',' '))+"\"");
      result.append(anchor + "<reflink>\n");

      return result.toString();
   }

   // PRIVATE FUNCTIONS

   private static String createAuthorList ( Author[] authors, String pad ) {
      String result = "";
      if ( authors == null ) return result;
      for (int i=0; i<authors.length; i++)
         result = result + pad + authors[i].toXML(pad);
      return result;
   }

   private static String oamsDisplayID(String pad, String displayID) {
      if ( displayID == null || displayID == "" ) return "";
      return pad + "<oams:displayID>\n"+displayID+"\n</oams:displayID>\n";
   }

   private static String dcDisplayID(String pad, Vector displayID) {
      if ( displayID == null || displayID.size() == 0 ) return "";
      String result = "";
      for (int i=0; i<displayID.size(); i++)
         result += ( pad + "<dc:identifier>\n"+
	    displayID.elementAt(i)+"\n"+pad+"</dc:identifier>\n" );
      return result;
   }

}
