// bergmark - July 2000 - Reference Linking Project

// CiteRefDatabase.java

// A collection of source-target pairs, sorted by target for helpful
// lookup.  The elements are URN (Document ID's)

// TBD: keep the vector sorted by target URN.  Maybe switch to a linked list.
// TBD: implement reload routine and save routine\

/** 2001/06/05 Set up a hashtable for the CiteRefDatabase
  * By: Yu Chen
  */

package Linkable.Utility;

import java.util.Vector;
import java.io.*;
import java.util.Enumeration;
import java.util.Hashtable;

public class CiteRefDatabase {

   private static final String ME = "CiteRefDatabase: ";
   private static final boolean DEBUG = CONFIG.DEBUG;

   private static Hashtable db = new Hashtable();
   private static String filename = CONFIG.CiteRefDB;

   /**
    * addCiteRef adds a new citeref to the database.
    * @param The first argument is the URN for the citing document.
    * @param The second argument is the URN for the cited document.
    */
   public static void addCiteRef ( String[] s, String t ) {

      if (DEBUG)
      System.err.println(ME + "Add Cite-Ref \"" +
          s[0] + " -- " + t + "\" to the CiteRefDatabase.");
      // create a new database if there isn't one
      if(db == null) {
	if (DEBUG)
        System.err.println("NULL CiteRefDatabase, create new one!");
        db = new Hashtable();
      }
      Vector newElements;
      // check if the key is in hashtable
      if((newElements = (Vector)db.get(t)) == null) {
       newElements = new Vector();
      }
      // update the citor's vector
      if(!newElements.contains(s)) {
       newElements.addElement(s);
       db.put(t, newElements);
       if (DEBUG) {
          System.err.println(ME + "New citors of \"" + t + "\" is:");
          System.err.println(ME + (Vector)db.get(t));
       }
      }
   }

   /**
    * Get citers returns a vector of URN's that cited the given URN.
    * The URN in the given URN is matched against target URN in the
    * existing database.
    * @param the URN for the cited document
    * @return Vector of URN's  (or null if no citers)
    */
   public static Vector findCiters ( String urn ) {

      if (DEBUG) {
         System.err.println(ME + "Find Citers for \"" + urn + "\"");
         System.err.println(ME + "Citers are: " +
           (Vector)db.get(urn));
      }
      return ((Vector)db.get(urn));
   }

   /**
     * Reloads the citeref database whose file is
     * given in the Linkable.Utility.CONFIG program.
     */
   public static void reload() {
      int n=0;     // number of records that we read from file
      db.clear();  // make the current database empty
      try {
        FileInputStream fis = new FileInputStream ( filename );
        ObjectInputStream ois = new ObjectInputStream ( fis );
	if (DEBUG)
        System.err.println(ME+"reloading the CiteRef database at "
                          + filename );
        CiteRef cr;
        while ( true ) {
          cr = (CiteRef)ois.readObject();
          n++;
          if ( DEBUG )
            System.err.println(ME+"("+n+")   "+cr.toString());
            addCiteRef(cr.source, cr.target);
        }
      } catch (Exception e) {}
      if (DEBUG)
      System.err.println(ME+" reloaded " + n + " citerefs from file");
   }

    /**
     * save the citeref Hashtable to the file whose name is given in CONFIG
     *
     */
    public static void save () {
       if (DEBUG)
       System.err.println(ME+"saving the citeref database of "
         + db.size() + " elements to " + filename);
       int n = 0;
       ObjectOutputStream oos = null;
       try {
          FileOutputStream fos = new FileOutputStream ( filename );
          oos = new ObjectOutputStream ( fos );

          for (Enumeration e = db.keys(); e.hasMoreElements(); ) {
            String _target = (String) e.nextElement();
            Vector c = (Vector) db.get(_target);
            for (int i=0; i<c.size(); i++) {
              String[] _source = (String[]) c.elementAt(i);
              oos.writeObject( new CiteRef(_source, _target));
              n++;
            }
          }
       } catch (Exception e) {e.printStackTrace();}

       try {
        oos.close();
       } catch (Exception e){e.printStackTrace();}
       if (DEBUG)
       System.err.println(ME+"wrote " + n + " records to file");
    }

    public static void update(String _completeUrn, String _incompleteUrn) {
      if (db.containsKey(_incompleteUrn)) {
        Vector citor =(Vector)db.remove(_incompleteUrn);
        db.put(_completeUrn, citor);
    }

    }

    /**
      * dump database to stdout
      *
      */
    public static void dump () {
      System.err.println(ME+"records in CiteRef database: " +
                        db.size());
      for (Enumeration e = db.keys(); e.hasMoreElements(); ) {
        String _target = (String) e.nextElement();
        Vector _source = (Vector) db.get(_target);
        System.err.println (ME + _source + " cites " + _target);
      }
    }

    public static Enumeration getKeys() {
      return db.keys();
    }
} // CiteRefDatabase
