// bergmark - october 2000 - the reference linking project

// CONFIG - hold constants that everybody can use

package Linkable.Utility;

import java.io.File;

// updates:
// 2000-11-20:  Add filenames for Surrogate data
// 2001-03-28:  Add filenames for jTidy output
// 2001-05-30:  Make filenames vary with directory

public class CONFIG {

   // The following constant is where surrogates get filed
   // They are stored in REPOSITORY + doi + "Surrogate"
   // An example DOI is 10.1024/december-99/12miller

   public static final String REPOSITORY = "/fsys/elgin/z/dienst/Repositories";

   // The following are the filenames found in the Surrogate directory
   public static final String myData = "myData";
   public static final String refList = "refList";
   public static final String knownCitations = "knownCitations";

   // The following constant is where the Creation Database
   // (i.e. fileIndex) is saved.  Required to resurrect surrogates.
   public static final String CreationDB = 
		  "/fsys/elgin/z/dienst/api_data/CreationDB";

   // The next two databases are optional
   public static final String AuthorDB = 
		  "/fsys/elgin/z/dienst/api_data/AuthorDB";

   public static final String CiteRefDB = 
		  "/fsys/elgin/z/dienst/api_data/CiteRefDB";

   // The following switch will (eventually) control whether or
   // not debugging output will go to stdout during program execution
   public static final boolean DEBUG = false;

   // The following filename is where jtidy puts its output
   // It must be an absolute pathname, because "file:" is prepended
   // to it to make the local URL.
   private static final File f1 = new File("tidyOutput.xml");
   private static final File f2 = f1.getAbsoluteFile();
   public static final String tidyOutput = f2.toString();
   //public static final String tidyOutput =
   //((new File("tidyOutput.xml")).getAbsoluteFile()).toString();

   // The following filename is where jtidy puts it error messages
   // It is a directory in the CWD
   public static final String tidyError = "Errors";

}
