// bergmark - April, 2000 - Reference Linking Project

// RefLinkAnalyzer is an interface that can analyze an Item.
// There are various extensions of this interface depending
// on the MIME type of the file being analysed.  Some deconstruct
// HTML directly, using Swing's text.html package.  Others
// convert to ascii and return an ascii analyzer.

package Linkable.Analysis;

import Linkable.API.*;
import java.util.Vector;

public interface RefLinkAnalyzer {

   public String buildLocalMetaData( String doi, String pubDate, Creation c );
   public Reference[] buildRefList( BibData b );
   public Vector buildCitationList( String docURN );
   public String getDate();

   // These entry points support getLinkedText

   /**
    * getLinkedTextInitialize sets up to generate XML for our Surrogate,
    * but not the <? xml version="1.0" ?> incantation.
    * @returns String to be added to the XML (including new lines)
    */
   public String getLinkedTextInitialize();

   /**
    * getLinkedText emits XML for the linked body of the text and/or the
    * characters of the text body followed by reference-link data suitable
    * for separate presentation.  Note that the reference-link data can be
    * constructed by this routine but saved for output by the
    * getLinkedTextFinalize routine.
    * @param The array of Reference objects belonging to this Surrogate.
    * @param the url of the document, to be used as a Base URL
    * @throws SurrogateException if the source to be linked cannot be opened.
    * @returns String to be added to the XML (including new lines)
    */
   public String getLinkedText ( Reference[] refList, String url )
   throws SurrogateException;

   /**
    * getLinkedTextFinalize emits XML for finishing off the Surrogate
    * linked text output.  The main
    * use for this routine is to emit the linkage data elements for
    * documents that are not expressed in HTML or in XHTML.
    * @returns String to be added to the XML (including new lines)
    */
   public String getLinkedTextFinalize ();

}
