// bergmark - April 2001 - Reference Linking Project

package Linkable.API;

// SurrogateException -
// throws package exceptions back to the user


/**
 * Handles two kinds of exceptions: usage and internal
 * Usage exceptions will explain what part of the input (url, file,
 * writable disk) prevented analysis.  Internal are bugs, and include
 * a traceback and a request to notify Donna Bergmark
 */

import java.lang.Exception;

/**
 * This class represents an exception thrown by the Surrogate if there
 * problems with any of its methods, or if an internal error occurred
 * that needs to be diagnosed.
 */

public class SurrogateException extends Exception {

   private String message = "error";
   private String type = " (usage): ";

   public SurrogateException() {super(); }

   /**
    * Constructor
    * @param s is a string explaining the reason for the exception
    */
   public SurrogateException(String s) {super(s); message = s;}

   /**
    * setInternal converts an error message into an internal system error message
    * @param s is a string explaining the reason for the exception
    */
   public static String setInternal (String s) {
      return "SurrogateException (internal):"+s+"\n"
      +"\nPlease send this error output to Donna Bergmark, "
      +"bergmark@cs.cornell.edu";
   }

}
