// Bergmark - April 2000 - The Reference Linking Project

// Citation is a class which contains information about a creation known
// to have cited this document.  It contains as much information as can
// be gotten.  The context(s) is stored only for CiteEnums REFERENCE
// and RI (ResearchIndex).  REFERENCE means that the citation was discovered
// while processing an item in an open archive.

// Modifications:
// 2000-07-28:    Citations have nothing to do with BibData objects, only
//                with Creations.
// 2000-11-16:    Context object replaces string

package Linkable.API;
import Linkable.Utility.Context;
/* import uk.ac.soton.harvester.Utils; */

/**
 * This class encapsulates information belonging to a Citation, that is,
 * information about a work that has this document as a reference,
 * how this document was cited, and in what context
 */

public class Citation {

   private static final String ME = "Creation: ";
   private static final boolean DEBUG = false;

   private Creation citationData;    // URI and XML of the citing creation
   private Context context[];        // context in the citing document
   private int how;                 // how this item was cited
   public static final int REFERENCE = 1;  // reference in analyzed paper
   public static final int SCI = 2;        // found out in the SCI
   public static final int RI = 3;         // from CiteSeer

   /** Constructor
    *@param Creation for the Citation
    *@param The contexts in which this item was cited
    *@param The citation type
    **/
   public Citation ( Creation bd, Context[] c, int h ) {
      context = new Context[c.length];
      citationData = bd;
      System.arraycopy(c,0,context,0,c.length);
      how = h;
   }

   /**
    * Accessor function for citation contexts
    * @returns handle to the Context[] array
    **/
   public Context[] getContext() {  // return all the contexts of this citation
      return context;
   }

   public String toString() {
      return "<CITATION>\n" +
             "  " + citationData.toString() + "\n" +
             "  " + "<contexts>\n" +
             listContexts("    ") +
             "  " + "</contexts>\n" +
             "  <type>" + listHow() + "</type>\n" +
             "</CITATION>";
   }

   // PRIVATE METHODS

   private String listContexts(String pad) {
      String result = "";
      for ( int i=0; i < context.length; i++ )
         result = result + context[i].toXML(pad);
      return result;
   }

   private String listHow ( ) {
      if ( how == REFERENCE ) return  "REFERENCE";
      else if ( how == SCI ) return  "From Citation Index";
      else if ( how == RI ) return "From Research Index";
      else return "unknown";
   }

}
